#ifndef   splines_h_INCLUDED
#define   splines_h_INCLUDED

#include <BsplineEval/bsplineval.h>

/* 
 *  splines.h -- spline deformation i/o and access methods
 */

#ifdef __cplusplus
/* prevent C++ name mangling */
extern "C" {
#endif

/*-----------------------
 * C callable interface
 */

void alloc_spline_coefs(void);
void free_spline_coefs(void);

void alloc_spline_workspaces(void);
void alloc_spline_data(void);
void free_spline_workspaces(void);
void free_spline_data(void);
void cread_spline_data( char const filename[] );
void read_fits_spline_data( char const filename[] );
void cwrite_spline_data( char const filename[] );
void write_fits_spline_data( char const filename[] );
void write_rdb( char const filename[] );

double eval_rms_amplitude(void);

void dump_s_scoef(void);

spline_coef*
get_spline_coef( void );

void
get_spline_hdr( int* z_order,
                int* theta_order,
                int* qz,
                int* num_z_knots,
                int* num_theta_knots );

void
set_spline_hdr( int z_order,
                int theta_order,
                int qz,
                int num_theta_knots );

void
get_spline_limits( double* zmin,
                   double* zmax,
                   double* tmin,
                   double* tmax );

void
set_spline_limits( double zmin,
                   double zmax,
                   double tmin,
                   double tmax );

void
get_spline_dataptrs( double** z_knots,
                     double** t_knots,
                     double** c,
                     double** cdifz,
                     double** cdift );

/*-----------------------
 * Fortran callable interface
 */

#define OPEN_FTN_IO_F77 F77_FUNC_(open_ftn_io,OPEN_FTN_IO)
void    OPEN_FTN_IO_F77(char const filename[], int const* io_unit,
                        int const* io_format, int const* io_direction,
                        int* iostat, long ln );

#define CLOSE_FTN_IO_F77 F77_FUNC_(close_ftn_io,CLOSE_FTN_IO)
void    CLOSE_FTN_IO_F77( int const* io_unit );

#define READ_SPLINE_DATA_F77 F77_FUNC_(read_spline_data,READ_SPLINE_DATA)
void    READ_SPLINE_DATA_F77( char const filename[], int const* io_unit,
                              double* rms_amplitude, long ln );

#define WRITE_SPLINE_DATA_F77 F77_FUNC_(write_spline_data,WRITE_SPLINE_DATA)
void    WRITE_SPLINE_DATA_F77( char const filename[], int const* io_unit,
                               int const* io_format, long ln );

#define READ_FTN_HDR_F77 F77_FUNC_(read_ftn_hdr,READ_FTN_HDR)
void    READ_FTN_HDR_F77( int const* io_unit, int const* io_format,
                          int* nzordr, int* qz, int* ntordr, int* ntknts,
                          double* zmin, double* zmax, double* tmin,
                          double* tmax, int* ier );

#define WRITE_FTN_HDR_F77 F77_FUNC_(write_ftn_hdr,WRITE_FTN_HDR)
void    WRITE_FTN_HDR_F77( int const* io_unit, int const* io_format,
                           int* nzordr, int* qz, int* ntordr, int* ntknts,
                           double* zmin, double* zmax, double* tmin,
                           double* tmax, int* ier );

#define READ_FTN_SPLDATA_F77 F77_FUNC_(read_ftn_spldata,READ_FTN_SPLDATA)
void    READ_FTN_SPLDATA_F77( int const* io_unit, int const* io_format,
                              double* z_knots, double* t_knots, double* c,
                              double* cdifz, double* cdift, double* scr,
                              int* qz, int* qzm1, int* ntknts );

#define WRITE_FTN_SPLDATA_F77 F77_FUNC_(write_ftn_spldata,WRITE_FTN_SPLDATA)
void    WRITE_FTN_SPLDATA_F77( int const* io_unit, int const* io_format,
                               double* z_knots, double* t_knots, double* c,
                               double* cdifz, double* cdift, double* scr,
                               int* qz, int* qzm1, int* ntknts );

#define SPLINE_EVAL_F77 F77_FUNC_(spline_eval,SPLINE_EVAL)
int     SPLINE_EVAL_F77( double const* theta, double const* zn,
                         double* s, double* dsdz, double* dsdt  );

#define SPLINE_CLEANUP_F77 F77_FUNC_(spline_cleanup,SPLINE_CLEANUP)
void    SPLINE_CLEANUP_F77( void );

#ifdef __cplusplus
}
#endif

#endif
