local tables     = require( 'saotrace.suplib.tables')
local setmetatable = setmetatable
local pairs = pairs

local spectrum = require( 'saotrace.raygen.spectrum' )
local picket = require('saotrace.raygen.spectrum.utils').picket

local M = {}
setfenv( 1, M )

-- the spectrum generator validators require a name to be passed, but
-- this interface doesn't want one, so create a filter function
-- to filter out the name specification from the validation

local function modify_vspec ( vspec_tbl, name )
   local vspec = tables.filter( vspec_tbl[name],
				function ( k )
				   if k == 'name' then
				      return false
				   else
				      return true
				   end
				end
			     )
   vspec.type = { type = 'string', enum = name, optional = true }
   return vspec
end

_vspec = {

   multiple = { allow_scalar = true },

   type = {

      unfluxed = {
	 optional = true,
	 type = 'posnum',
	 name = 'energy',
	 postcall = function( arg, vfargs )
		       local spectra = vfargs.va:getopt('udata').spectra
		       spectra:add(
			  spectrum.mono{ name = spectra:name( vfargs.name ),
					 energy = arg}
		       )
		    end,
      },


      fluxed = {
	 optional = true,
	 vtable = { { name = 'energy', type = 'posnum', named = true },
		    { name = 'flux',   type = 'posnum', default = 1, named = true },
		 },
	 postcall = function( arg, vfargs )
		       local spectra = vfargs.va:getopt('udata').spectra
		       arg.name = spectra:name(vfargs.name)
		       spectra:add( spectrum.mono( arg ) )
		    end,

      },

      picket = {
	 optional = true,
	 vtable = {
	    file   = { type = 'string' },
	    energy = { type = 'string', default = 'energy' },
	    flux   = { type = 'string', default = 'flux' },
	    type   = { enum = 'picket'  },
	 },
	 postcall = picket
      },

      flat = {
	 optional = true,
	 vtable = modify_vspec( spectrum.vspec, 'flat' ),
	 postcall = function( arg, vfargs )
		       local spectra = vfargs.va:getopt('udata').spectra
		       arg.name = spectra:name( vfargs.name )
		       arg.type = nil
		       spectra:add( spectrum.flat( arg ) )
		    end,
      },

      file = {
	 optional = true,
	 vtable = modify_vspec( spectrum.vspec, 'file' ),
	 postcall = function( arg, vfargs )
		       local spectra = vfargs.va:getopt('udata').spectra
		       arg.name = spectra:name( arg.file )
		       arg.type = nil
		       spectra:add( spectrum.file( arg ) )
		    end
      },

   },

}

function M:new()

   local obj = {}
   obj._vspec = tables.copy( self._vspec, true )
   setmetatable( obj, self )
   self.__index = self

   return obj

end

function M:vspec()
   return self._vspec
 end

function M:add( name, entry )

   self._vspec.type[name] = entry

end

function M:delete( name )

   self._vspec.type[name] = nil

end

return M
