#!/bin/csh -f

set path = ( '/opt/saotrace-2.0.5/bin' $path )

setenv SAOTRACE_VERSION "2.0.5"

# avoid excess verbiage if MANPATH or INFOPATH don't already exist

if ( $?MANPATH ) then
  if ( "$MANPATH" != ""  ) then
    setenv MANPATH   "${MANPATH}:/opt/saotrace-2.0.5/share/man"
  endif
else
  setenv MANPATH   "/opt/saotrace-2.0.5/share/man"
endif

if ( $?INFOPATH ) then
  if ( "$INFOPATH" != "" ) then
    setenv INFOPATH  "${INFOPATH}:/opt/saotrace-2.0.5/share/info"
  endif
else
  setenv INFOPATH  "/opt/saotrace-2.0.5/share/info"
endif

if ( ! $?PFILES ) then
  setenv PFILES ''
endif

if ( "$PFILES" != "" ) then
    if ( $PFILES =~ *\;* ) then
      setenv PFILES `echo "$PFILES" | sed -e 's,;,;/opt/saotrace-2.0.5/share/uparm:,' -e 's/:$//g'`
    else
      setenv PFILES "${PFILES};/opt/saotrace-2.0.5/share/uparm"
    endif
else
  setenv PFILES './;/opt/saotrace-2.0.5/share/uparm'
endif

if ( $?LUA_CPATH ) then
  if ( "$LUA_CPATH" != "" ) then
    setenv LUA_CPATH  ";;${LUA_CPATH}"
  else
    unsetenv LUA_CPATH
  endif
endif

if ( $?LUA_CPATH ) then
  if ( "$LUA_CPATH" != "" ) then
    setenv LUA_CPATH  ";;${LUA_CPATH}"
  else
    unsetenv LUA_CPATH
  endif
endif

if ( $?PERL5LIB ) then
  if ( "$PERL5LIB" != "" ) then
    setenv PERL5LIB "/opt/saotrace-2.0.5/lib/perl5:$PERL5LIB"
  else
    setenv PERL5LIB "/opt/saotrace-2.0.5/lib/perl5"
  endif
else
    setenv PERL5LIB "/opt/saotrace-2.0.5/lib/perl5"
endif
