#ifndef LINKLIST_H
#define LINKLIST_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of linklist
 *
 * linklist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * linklist is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#ifdef __cplusplus
extern "C" {
#endif

#define SLL_NULL_CMP ( (int (*)(const void *, const void *)) NULL )
#define DLL_NULL_CMP ( (int (*)(const void *, const void *)) NULL )

#define SLL_NULL_DELETE ( (void (*)(void *)) NULL )
#define DLL_NULL_DELETE ( (void (*)(void *)) NULL )

#define SLL_CMP int (*)(const void *, const void *)
#define DLL_CMP int (*)(const void *, const void *)

#define SLL_DELETE void (*)(void *)
#define DLL_DELETE void (*)(void *)

#define SLL_ACTION int (*)(void *)
#define DLL_ACTION int (*)(void *)

typedef void * DLinkList;
typedef void * DLLNode;

typedef void * SLinkList;
typedef void * SLLNode;

typedef enum
{
  HEAD_TO_TAIL, TAIL_TO_HEAD
} LinkTraverseDirection;

#include <stddef.h>

#if defined(__STDC__) || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif /* __STDC_ || __cplusplus */

/* slinklist.c */
extern SLinkList sll_new(int (*cmp)(const void *, const void *));
extern void sll_delete(SLinkList ull, void (*ufree)(void *));
extern void sll_udelete(SLinkList ull, void (*ufree)(void *, void *), void *udata);
extern void *sll_destroy(SLinkList ull, void *data, int (*cmp)(const void *, const void *));
extern void *sll_destroy_head(SLinkList ull);
extern void *sll_destroy_tail(SLinkList ull);
extern size_t sll_count(SLinkList ull);
extern void sll_destroy_dnode(SLLNode unode);
extern void *sll_destroy_node(SLinkList ull, SLLNode unode);
extern void sll_detach_node(SLinkList ull, SLLNode unode);
extern int sll_insert(SLinkList ull, void *data);
extern int sll_insert_node(SLinkList ull, SLLNode unode);
extern int sll_insert_head(SLinkList ull, void *data);
extern int sll_insert_head_node(SLinkList ull, SLLNode unode);
extern int sll_insert_tail(SLinkList ull, void *data);
extern int sll_insert_tail_node(SLinkList ull, SLLNode unode);
extern void *sll_head(SLinkList ull);
extern SLLNode sll_head_node(SLinkList ull);
extern SLLNode sll_detach_head_node(SLinkList ull);
extern void *sll_tail(SLinkList ull);
extern SLLNode sll_tail_node(SLinkList ull);
extern size_t sll_sizeof_node(void);
extern void *sll_next(SLinkList ull, SLLNode unode);
extern SLLNode sll_next_node(SLinkList ull, SLLNode unode);
extern void *sll_prev(SLinkList ull, SLLNode unode);
extern SLLNode sll_prev_node(SLinkList ull, SLLNode unode);
extern void *sll_node_get_data(SLLNode unode);
extern void sll_node_put_data(SLLNode unode, void *data);
extern void *sll_search(SLinkList ull, void *data, int (*cmp)(const void *, const void *));
extern SLLNode sll_search_node(SLinkList ull, void *data, int (*cmp)(const void *, const void *));
extern int sll_traverse(SLinkList ull, int (*action)(void *));
extern int sll_traverse_d(SLinkList ull, int (*action)(void *), void *ndata);
extern int sll_utraverse(SLinkList ull, int (*action)(void *node, void *udata), void *udata);
extern int sll_utraverse_d(SLinkList ull, int (*action)(void *node, void *udata), void *udata, void *ndata);
extern void sll_join(SLinkList dst_ull, SLinkList src_ull);
/* dlinklist.c */
extern DLinkList dll_new(int (*cmp)(const void *, const void *));
extern void dll_delete(DLinkList ull, void (*ufree)(void *));
extern void dll_udelete(DLinkList ull, void (*ufree)(void *, void *), void *udata);
extern void *dll_destroy(DLinkList ull, void *data, int (*cmp)(const void *, const void *));
extern void *dll_destroy_head(DLinkList ull);
extern void *dll_destroy_tail(DLinkList ull);
extern size_t dll_count(DLinkList ull);
extern void dll_destroy_dnode(DLLNode unode);
extern void *dll_destroy_node(DLinkList ull, DLLNode unode);
extern void dll_detach_node(DLinkList ull, DLLNode unode);
extern int dll_insert(DLinkList ull, void *data);
extern int dll_insert_node(DLinkList ull, DLLNode unode);
extern int dll_insert_head(DLinkList ull, void *data);
extern int dll_insert_head_node(DLinkList ull, DLLNode unode);
extern int dll_insert_tail(DLinkList ull, void *data);
extern int dll_insert_tail_node(DLinkList ull, DLLNode unode);
extern void *dll_head(DLinkList ull);
extern DLLNode dll_head_node(DLinkList ull);
extern DLLNode dll_detach_head_node(DLinkList ull);
extern void *dll_tail(DLinkList ull);
extern DLLNode dll_tail_node(DLinkList ull);
extern size_t dll_sizeof_node(void);
extern void *dll_next(DLinkList ull, DLLNode unode);
extern DLLNode dll_next_node(DLinkList ull, DLLNode unode);
extern void *dll_prev(DLinkList ull, DLLNode unode);
extern DLLNode dll_prev_node(DLinkList ull, DLLNode unode);
extern void *dll_node_get_data(DLLNode unode);
extern void dll_node_put_data(DLLNode unode, void *data);
extern void *dll_search(DLinkList ull, void *data, int (*cmp)(const void *, const void *));
extern DLLNode dll_search_node(DLinkList ull, void *data, int (*cmp)(const void *, const void *));
extern int dll_traverse(DLinkList ull, int (*action)(void *), LinkTraverseDirection direction);
extern int dll_traverse_d(DLinkList ull, int (*action)(void *), LinkTraverseDirection direction, void *ndata);
extern int dll_utraverse(DLinkList ull, int (*action)(void *node, void *udata), void *udata, LinkTraverseDirection direction);
extern int dll_utraverse_d(DLinkList ull, int (*action)(void *node, void *udata), void *udata, LinkTraverseDirection direction, void *ndata);
extern void dll_join(DLinkList dst_ull, DLinkList src_ull);

#undef P_


#ifdef __cplusplus
}
#endif

#endif /* ! LINKLIST_H */
