#ifndef rl_Exception_H
#define rl_Exception_H

// --8<--8<--8<--8<--
//
// Copyright (C) 2007 Smithsonian Astrophysical Observatory
//
// This file is part of rl_raylib
//
// rl_raylib is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// rl_raylib is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the 
//       Free Software Foundation, Inc. 
//       51 Franklin Street, Fifth Floor
//       Boston, MA  02110-1301, USA
//
// -->8-->8-->8-->8--

#include <string>
#include <Exception/Exception.h>

/**
 * \class rl_Exception
 *
 * The exception thrown by the rl_RayLib and rl_RaySupLib libraries.
 */
class rl_Exception : public Exception {

public:

  /// Destructor
  ~rl_Exception( );

  /// Include a string describing the exception
  rl_Exception( const std::string& msg );

  /// Format a string describing the exception
  rl_Exception( const char* format, ... );

};

#endif
