#ifndef DATATYPES_H
#define DATATYPES_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2005-2011 Smithsonian Astrophysical Observatory
 *
 * This file is part of bpipe
 *
 * bpipe is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * -->8-->8-->8-->8-- */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  double x;
  double y;
}DVector2;

typedef struct
{
  double x;
  double y;
  double z;
}DVector3;

typedef struct
{
  int x;
  int y;
}IVector2;

typedef struct
{
  int x;
  int y;
  int z;
}IVector3;

typedef struct
{
  unsigned int x;
  unsigned int y;
}UIVector2;

typedef struct
{
  unsigned int x;
  unsigned int y;
  unsigned int z;
}UIVector3;

/* Kludge to deal with Numerical Recipes.  The structure of the
   structure is the same. (How many ways are there to stuff complex
   numbers into a structure)? The namespace issue is the problem */

#ifndef _DCOMPLEX_DECLARE_T_

typedef struct
{
  double r;
  double i;
}DComplex;

/* for backwards compatibility with code which used NR */
typedef DComplex dcomplex;

#else

typedef dcomplex DComplex;

#endif /* _DCOMPLEX_DECLARE_T_ */

typedef struct
{
  DComplex q1;
  DComplex q2;
}DCVector2;

typedef struct
{
  DComplex q1;
  DComplex q2;
  DComplex q3;
}DCVector3;

#ifdef __cplusplus
}
#endif

#endif  /* !DATATYPES_H */
