#ifndef TPARAMS_H
#define TPARAMS_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of tparam
 *
 * tparam is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * tparam is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 *       Free Software Foundation, Inc.
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */


#include <cxcparam/parameter.h>

paramfile tparamopen(const char *filename, char **argv, int argc, const char *mode);
short tpgets(paramfile pf, const char *pname);
int tpgeti(paramfile pf, const char *pname);
double tpgetd(paramfile pf, const char *pname);
float tpgetf(paramfile pf, const char *pname);
int tpgetb(paramfile pf, const char *pname);
char *tpgetstr(paramfile pf, const char *pname, char *val, int nchars, int abort_if_empty);


#endif /* ! TPARAMSXX_H */
