local math = require('math')
local tables   = require( 'saotrace.suplib.tables' )

local chandra_coords   = require( 'chandra.saotrace.coords' )
local raygen_coords   = require( 'saotrace.raygen.coords' )
local units = require( 'saotrace.raygen.units' )

local MSC_to_raygen_polar = chandra_coords.MSC_to_raygen_polar
local raygen_elaz_2_raygen_polar = raygen_coords.raygen_elaz_2_raygen_polar

local VSpec = require( 'saotrace.raygen.position.vspec' )

local M = {}
setfenv( 1, M )

local spec = VSpec:new()

-- and add in some chandra ones

spec:add( 'chandra-msc', {
	      vtable = {
		 theta = { type = 'zpos_angle_arcminute', default = { 0, units.angular.radian} },
		 phi   = { type = 'zpos_angle_degree',    default = { 0, units.angular.radian} },
		 coord = { enum = 'chandra-msc' }
	      },
	      postcall = function( arg )
			    local theta, phi = MSC_to_raygen_polar( arg.theta[1], arg.phi[1] )
			    return true, { theta = { theta, units.angular.radian },
					   phi   = { phi, units.angular.radian }, }
			 end

	   }
	)

spec:add( 'chandra-equatorial',{
	      vtable = {
		 ra  = { type = 'angle_ra' },
		 dec = { type = 'angle_dec' },
		 ra_aimpt = { type = 'angle_ra' },
		 dec_aimpt = { type = 'angle_dec' },
		 coord = { enum = 'chandra-equatorial', optional = true }
	      },
	      postcall = function( arg )

			    local theta, phi
			       = raygen_coords.delta_equatorial( arg.ra_aimpt[1],
								 arg.dec_aimpt[1],
								 arg.ra[1],
								 arg.dec[1] )

			    return true, { theta = { theta, units.angular.radian },
					   phi =  { phi + math.pi * 3/2, units.angular.radian  },
						}
			 end

	   }
	)

spec:add( 'chandra-offset', {

	      vtable = {
		 zoff = { type = 'angle_arcminute', default = 0 },
		 yoff = { type = 'angle_arcminute', default = 0 },
		 coord = { enum = 'chandra-offset', optional = true },
	      },

	      postcall = function( arg )
			    local theta, phi = raygen_elaz_2_raygen_polar( -arg.zoff[1], arg.yoff[1] )
			    return true, { theta = { theta, units.angular.radian },
					   phi   = { phi, units.angular.radian },
					}
			 end
	   }
	)

spec:default( 'chandra-msc' )

vspec = spec:vspec()

return M
