#ifndef simpleRDBTable_H
#define simpleRDBTable_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of RDB
 *
 * RDB is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * RDB is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <iostream>

#include <suplibxx/str.h>
#include <Exception/Exception.h>

#include <rdbxx/RDBColumn.h>
#include <rdbxx/RDB.h>

/**
 *
 * A simple interface to the RDB++ read a row of an rdb table to initialize
 * a class Type. The class Type must have a constructor with the following
 * prototype:
 *
 *  Type( const char* header[], RDBColumn** rdb_column )
 *
 */
template< class Type >
class simpleRDBTable : public RDB {

  friend std::ostream& operator << ( std::ostream& os, simpleRDBTable< Type >& a ) {
    a.print( os );
    return os;
  }

  friend std::ostream& operator << ( std::ostream& os, simpleRDBTable< Type >* a ) {
    a->print( os );
    return os;
  }

public:

  ~simpleRDBTable( );

  simpleRDBTable( const std::string& fname, const int mode,
		  const char* header[] )
   ;

  /// Given an RDBColumn, get a string value
  static void getData( RDBColumn* rdbcol, std::string& val );

  /// Given an RDBColumn, get an integer value
  static void getData( RDBColumn* rdbcol, int& val );

  /// Given an RDBColumn, get a long value
  static void getData( RDBColumn* rdbcol, long& val );

  /// Given an RDBColumn, get a double value
  static void getData( RDBColumn* rdbcol, double& val );

  void print( std::ostream& os ) const;

  /// Read a row of the RDB table.
  Type* readRow( );

protected:

  const char** rdb_header;

  RDBColumn** rdb_column;

private:

  /// Following the lead of the base class.
  simpleRDBTable( ) : rdb_header( NULL ), rdb_column( NULL ) { }

  // Declare but (purposedly) not define
  simpleRDBTable< Type >( const simpleRDBTable< Type >& c );

  // Declare but (purposedly) not define
  simpleRDBTable< Type >& operator = ( const simpleRDBTable< Type >& rhs );

  size_t count_num_args( const char* str[] );

};

#ifndef simpleRDBTable_cc
#include <rdbxx/simpleRDBTable.cc>
#endif

#endif
