#ifndef MyPhoton_H
#define MyPhoton_H

// --8<--8<--8<--8<--
//
// Copyright (C) 2006 Smithsonian Astrophysical Observatory
//
// This file is part of BinaryPipe
//
// BinaryPipe is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// BinaryPipe is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the 
//       Free Software Foundation, Inc. 
//       51 Franklin Street, Fifth Floor
//       Boston, MA  02110-1301, USA
//
// -->8-->8-->8-->8--

#include <bpipe/bpipe.h>
#include <bpipe/bpipe_axaf.h>
#include <bpipe/datatypes.h>

#include <BinaryPipe/BinaryPipeException.h>

class MyPhoton {

  /**
   * This operator outputs the contents of the object.
   */
  friend std::ostream& operator << ( std::ostream& os, MyPhoton& photon ) {
    photon.print( os );
    return os;
  }

  /**
   * This operator outputs the contents of the object.
   */
  friend std::ostream& operator << ( std::ostream& os, MyPhoton* photon ) {
    photon->print( os );
    return os;
  }

public:

  MyPhoton( BPipe* bpipe, void* core ) throw ( BinaryPipeException );

  DVector3* get_position( ) { return position; }

  DVector3* get_direction( ) { return direction; }
    
  virtual void print( std::ostream& os ) const;

protected:

  DVector3* position;

  DVector3* direction;

  char *dpktf_data( BPipe* bpipe, void* core, const char *name ) const
    throw ( BinaryPipeException );

};

#endif
