#ifndef BPIPE_PROTOS_H
#define BPIPE_PROTOS_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2005-2011 Smithsonian Astrophysical Observatory
 *
 * This file is part of bpipe
 *
 * bpipe is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * -->8-->8-->8-->8-- */


#ifdef __cplusplus
extern "C" {
#endif

/* bpipe.c */
extern BPipe *bpipe_new(void);
extern void bpipe_delete(BPipe *bpipe);

/* datatypes.c */
extern size_t bpipe_datatype_size(BPDataType type);
extern size_t bpipe_datatype_raw_size(BPDataType type);
extern const char *bpipe_datatype_name(BPDataType type);
extern BPDataType bpipe_datatype_resolve(const char *datatype);
extern int bpipe_datatype_write(IOchannel *channel, BPDataType type);
extern int bpipe_datatype_copy(size_t dst, size_t src, size_t nobjs, BPDataType type, BPXMap map, void *udata, int (*copy)(void *, size_t, size_t, size_t));
extern void bpipe_datatype_init(void *dst, BPDataType type, size_t n);
extern void bpipe_datatype_init_output(void *dst, BPDataType type, size_t n);
extern void bpipe_data_copy(void *dst, void *src, BPMatrix *matrix, BPDataType type);

/* dpkt.c */
extern int bpipe_dpkt_setup(BPipe *bpipe);
extern void bpipe_dpkt_cleanup(BPipe *bpipe);
extern size_t bpipe_dpkt_n(BPipe *bpipe );
extern DpktField *bpipe_dpktf(BPipe *bpipe, const char *name);
extern DpktField *bpipe_dpktf_next(BPipe *bpipe, void **p_last);
extern BPDataType bpipe_dpktf_type(DpktField *dpktf);
extern void *bpipe_dpktf_datap(BPipe *bpipe, void *core_image, const char *name, BPDataType type);
extern const char *bpipe_dpktf_name(DpktField *dpktf);
extern BPMatrix *bpipe_dpktf_matrix(DpktField *dpktf, BPDataSite site, BPipeOutput *channel);
extern int bpipe_dpktf_newP(BPipe *bpipe, const char *name, BPDataType type, BPMatrix *matrix, size_t offset, BPDataSite site);
extern int bpipe_dpktf_add(BPipe *bpipe, const char *name, BPDataType type, BPMatrix *matrix);
extern int bpipe_dpktf_array_add(BPipe *bpipe, const char *name, BPDataType type, size_t extent);
extern int bpipe_dpktf_delete(BPipe *bpipe, const char *name, BPDataSite site, BPipeOutput *channel);
extern void bpipe_dpktf_init(DpktField *field, void *dpkt, void *init);
extern int dpktf_node_name_cmp(const void *dpktf1, const void *dpktf2);
extern int bpipe_dpktf_size_cmp(const void *dpktf1, const void *dpktf2);

/* dpkt_io.c */
extern size_t bpipe_read_dpkts(BPipe *bpipe, void *buf, size_t n_pkts);
extern size_t bpipe_write_dpkt_n(BPipe *bpipe, void *buf, size_t n_pkts, BPipeOutput *bpo);
extern int bpipe_write_dpkt(BPipe *bpipe, void *buf, BPipeOutput *bpo);
extern int bpipe_write_dpkts(BPipe *bpipe, void *buf, size_t n_pkts, BPipeOutput *bpo);

/* dpktf_resize.c */
extern int bpipe_dpktf_resize_core(DpktField *dpktf, BPMatrix *matrix, size_t src_off[], size_t dst_off[], size_t extent[]);
extern int bpipe_dpktf_resize_output(DpktField *dpktf, BPMatrix *matrix, size_t src_off[], size_t dst_off[], size_t extent[], BPipeOutput *bpo);

/* errno.c */
extern BPerrno bpipe_errno;
extern char *bpipe_strerror(BPerrno errnum);

/* hdr.c */
extern int bpipe_hdr_setup(BPipe *bpipe);
extern void bpipe_hdr_cleanup(BPipe *bpipe);
extern size_t bpipe_hdrf_n(BPipe *bpipe, const char *name);
extern BPDataType bpipe_hdrf_type(BPipe *bpipe, const char *name, size_t index);
extern void *bpipe_hdrf_data(BPipe *bpipe, const char *name, size_t index);
extern BPMatrix *bpipe_hdrf_matrix(BPipe *bpipe, const char *name, size_t index);
extern int bpipe_hdrf_resize(BPipe *bpipe, const char *name, size_t index, BPMatrix *matrix, size_t src_off[], size_t dst_off[], size_t extent[], void *init, size_t n_init);
extern int bpipe_hdrf_next(BPipe *bpipe, const char **p_name, size_t *p_index, void **p_last);
extern int bpipe_hdrf_delete(BPipe *bpipe, const char *name, size_t index);
extern int bpipe_hdrf_add(BPipe *bpipe, const char *name, BPDataType type, BPMatrix *matrix, void *data, int copy);
extern int bpipe_hdrf_string_add(BPipe *bpipe, const char *name, char *data, size_t len, int copy);
extern int bpipe_hdrf_array_add(BPipe *bpipe, const char *name, BPDataType type, void *data, size_t extent, int copy);

/* input.c */
extern int bpipe_input(BPipe *bpipe, const char *path);
extern BPMatrix *bpipe_proc_def(char *buf, char **name, BPDataType *type);

/* iochannel.c */
extern IOchannel *bpipe_iochannel_new(const char *path);
extern int bpipe_iochannel_open(IOchannel *ioc, const char *mode);
extern void bpipe_iochannel_close(IOchannel *ioc);
extern void bpipe_iochannel_delete(IOchannel *ioc);
extern size_t bpipe_iochannel_read(void *buf, size_t size, size_t n, IOchannel *ioc);
extern size_t bpipe_iochannel_write(const void *buf, size_t size, size_t n, IOchannel *ioc);
extern char *bpipe_iochannel_fgetrn(char **buf, size_t *buf_len, IOchannel *ioc);

/* map.c */
extern size_t bpipe_map(BPipe *bpipe);
extern void *bpipe_map_alloc(BPipe *bpipe, int ndpkts, size_t *size_p);

/* matrix.c */
extern void bpipe_matrix_delete(BPMatrix *matrix);
extern BPMatrix *bpipe_matrix_dup(BPMatrix *src);
extern BPMatrix *bpipe_matrix_new_va(size_t nd, ...);
extern BPMatrix *bpipe_matrix_new(size_t nd, size_t extent[]);
extern int bpipe_matrix_verify(BPMatrix *matrix);
extern BPMatrix *bpipe_matrix_min(BPMatrix *a, BPMatrix *b);
extern BPMatrix *bpipe_matrix_max(BPMatrix *a, BPMatrix *b);
extern BPMatrix *bpipe_matrix_squeeze( BPMatrix *matrix );
extern BPMatrix *bpipe_matrix_crunch( BPMatrix *matrix );

/* matrix_copy.c */
extern int bpipe_matrix_copy(BPDataType type, BPXMap xmap, BPMatrix *src, BPMatrix *dst, BPMatrixMap *map, void *udata, int (*copy)(void *udata, size_t dest, size_t src, size_t nbytes));
extern int bpipe_check_matrix_copy(BPMatrix *src, BPMatrix *dst, BPMatrixMap *map);

/* matrix_map.c */
extern BPMatrixMap *bpipe_matrix_map_new(BPMatrix *src, size_t src_off[], BPMatrix *dst, size_t dst_off[], size_t extent[]);
extern BPMatrixMap *bpipe_matrix_map_expand(BPMatrix *src, BPMatrix *dst, BPMatrixMap *map);
extern BPMatrixMap *bpipe_matrix_map_dup(BPMatrix *src, BPMatrix *dst, BPMatrixMap *src_map, int create_empty);
extern void bpipe_matrix_map_delete(BPMatrixMap *map);

/* matrix_override.c */
extern BPMatrixOverride *bpipe_matrix_override_new(DpktField *dpktf, BPMatrix *src, size_t src_off[], BPMatrix *dst, size_t dst_off[], size_t extent[]);
extern void bpipe_matrix_override_delete(BPMatrixOverride *over);
extern int bpipe_dpktf_matrix_override_cmp(const void *d, const void *m);

/* misc.c */
extern void *bpipe_data_dup(void *data, size_t n, size_t size, int create_empty);
extern void *bpipe_extent_new_va(size_t nd, ...);
extern void *bpipe_extent_new(size_t nd, size_t init);
extern size_t *bpipe_offset_new_va(size_t nd, ...);
extern size_t *bpipe_offset_new(size_t nd, size_t init);
extern int bpipe_check_field_name(const char *name);
extern void bpipe_memfill(void *dstp, size_t n_dst, void *srcp, size_t n_src, size_t size);

/* output.c */
extern BPipeOutput *bpipe_output(BPipe *bpipe, const char *path);
extern void bpipe_output_delete(BPipeOutput *bpo);

/* sprintf.c */
extern int bpipe_sprintf(char *s, const void *data, BPDataType type, char * const formats[]);

/* write_hdr.c */
extern int bpipe_write_hdr(BPipe *bpipe);


#ifdef __cplusplus
}
#endif


#endif /* ! BPIPE_PROTOS_H */
