// -*-c++-*-

#ifndef CXCPARAMX_SIMPLE_H
#define CXCPARAMX_SIMPLE_H

#include <memory>
#include <string>

#include <Exception/Exception.h>

namespace cxcparamx {

    using std::string;


    class simple {

    public:

	simple( int argc,  char** argv, const string& mode = "rw" );
	simple( const string& filename, int argc, char** argv, const string& mode = "rw" );

        void get( const string& name, float& value ) const;
	void get( const string& name, double& value ) const;
	void get( const string& name, short& value ) const;
	void get( const string& name, int& value ) const;
	void get( const string& name, long& value ) const;
	void get( const string& name, bool& value ) const;
	void get( const string& name, string& value ) const;

	float  getf( const string& name ) const;
	double getd( const string& name ) const;
	short  gets( const string& name ) const;
	int    geti( const string& name ) const;
	long   getl( const string& name ) const;
	bool   getb( const string& name ) const;
	string getstr( const string& name ) const;

        bool access( const string& name ) const;


        struct  ParamFileImpl;
        using  pParamFileImpl = std::unique_ptr<ParamFileImpl, void(*)(ParamFileImpl*)>;

   private:

        simple( simple& ) = delete;
        simple& operator=( simple& ) = delete;

        void access_t(  const string& name ) const;

        pParamFileImpl pf;

	string filename;
    };

}

#endif // ! CXCPARAMX_SIMPLE_H
