#ifndef _NR_UTILS_H_
#define _NR_UTILS_H_

#define NR_END 1

#ifdef NRUTIL_MACROS

static float sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : sqrarg*sqrarg)

static double dsqrarg;
#define DSQR(a) ((dsqrarg=(a)) == 0.0 ? 0.0 : dsqrarg*dsqrarg)

static double dmaxarg1,dmaxarg2;
#define DMAX(a,b) (dmaxarg1=(a),dmaxarg2=(b),(dmaxarg1) > (dmaxarg2) ?\
        (dmaxarg1) : (dmaxarg2))

static double dminarg1,dminarg2;
#define DMIN(a,b) (dminarg1=(a),dminarg2=(b),(dminarg1) < (dminarg2) ?\
        (dminarg1) : (dminarg2))

static float maxarg1,maxarg2;
#define FMAX(a,b) (maxarg1=(a),maxarg2=(b),(maxarg1) > (maxarg2) ?\
        (maxarg1) : (maxarg2))

static float minarg1,minarg2;
#define FMIN(a,b) (minarg1=(a),minarg2=(b),(minarg1) < (minarg2) ?\
        (minarg1) : (minarg2))

static long lmaxarg1,lmaxarg2;
#define LMAX(a,b) (lmaxarg1=(a),lmaxarg2=(b),(lmaxarg1) > (lmaxarg2) ?\
        (lmaxarg1) : (lmaxarg2))

static long lminarg1,lminarg2;
#define LMIN(a,b) (lminarg1=(a),lminarg2=(b),(lminarg1) < (lminarg2) ?\
        (lminarg1) : (lminarg2))

static int imaxarg1,imaxarg2;
#define IMAX(a,b) (imaxarg1=(a),imaxarg2=(b),(imaxarg1) > (imaxarg2) ?\
        (imaxarg1) : (imaxarg2))

static int iminarg1,iminarg2;
#define IMIN(a,b) (iminarg1=(a),iminarg2=(b),(iminarg1) < (iminarg2) ?\
        (iminarg1) : (iminarg2))

#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))

#endif /* NRUTIL_MACROS */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
#if defined(__STDC__) || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif /* __STDC_ || __cplusplus */
/* mst_nrutil.c */
extern float *vector_r(long nl, long nh);
extern int *ivector_r(long nl, long nh);
extern unsigned char *ucvector_r(long nl, long nh);
extern char *cvector_r(long nl, long nh);
extern long *lvector_r(long nl, long nh);
extern unsigned long *ulvector_r(long nl, long nh);
extern double *dvector_r(long nl, long nh);
extern float **matrix_r(long nrl, long nrh, long ncl, long nch);
extern double **dmatrix_r(long nrl, long nrh, long ncl, long nch);
extern int **imatrix_r(long nrl, long nrh, long ncl, long nch);
extern long **lmatrix_r(long nrl, long nrh, long ncl, long nch);
extern float **submatrix_r(float **a, long oldrl, long oldrh, long oldcl, long oldch, long newrl, long newcl);
extern float **convert_matrix_r(float *a, long nrl, long nrh, long ncl, long nch);
extern int ***i3tensor_r(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
extern float ***f3tensor_r(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
extern double ***d3tensor_r(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
extern void free_vector(float *v, long nl, long nh);
extern void free_ivector(int *v, long nl, long nh);
extern void free_cvector(char *v, long nl, long nh);
extern void free_ucvector(unsigned char *v, long nl, long nh);
extern void free_lvector(long *v, long nl, long nh);
extern void free_ulvector(unsigned long *v, long nl, long nh);
extern void free_dvector(double *v, long nl, long nh);
extern void free_matrix(float **m, long nrl, long nrh, long ncl, long nch);
extern void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch);
extern void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch);
extern void free_lmatrix(long **m, long nrl, long nrh, long ncl, long nch);
extern void free_submatrix(float **b, long nrl, long nrh, long ncl, long nch);
extern void free_convert_matrix(float **b, long nrl, long nrh, long ncl, long nch);
extern void free_i3tensor(int ***t, long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
extern void free_f3tensor(float ***t, long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
extern void free_d3tensor(double ***t, long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
#undef P_
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _NR_UTILS_H_ */
