#ifndef SUPLIB_IO_H
#define SUPLIB_IO_H

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of suplib
 *
 * suplib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * suplib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

char *	fget_rec_read( FILE *fin, void *recbuf, size_t start );
char *	fget_rec( FILE *fin, void *recbuf );
char *	fget_rec_append( FILE *fin, void *recbuf );
void *	fget_rec_new(size_t buf_size, size_t extend);
void	fget_rec_delete(void *rec);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* SUPLIB_IO_H */
