#ifndef  test_h_INCLUDED
#define  test_h_INCLUDED
/*
//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Revised 1997 Dec 12, D. Jerius
//   - add support for C as well as C++
//   - add source line # output
// Revised 1997 May 30, T. J. Gaetz
//   - add fuzzy fp compare support
// Revised 1997 May 17, T. J. Gaetz
//   - bundle into struct to clean up global namespace.
*/

#ifndef stddef_h_INCLUDED
#include <stddef.h>
#define stddef_h_INCLUDED
#endif

#ifndef string_h_INCLUDED
#include <string.h>
#define string_h_INCLUDED
#endif

#ifndef float_h_INCLUDED
#include <float.h>
#define float_h_INCLUDED
#endif

#define __TESTDFLT_TOL (100.0 * DBL_EPSILON)

#ifdef CPLUSPLUSandC

/* If the the testlib lib is to be installed as a C and C++ lib */

#ifdef __cplusplus

struct Test
{
  static void start(char* name);
  static void begin(const char* msg, size_t line_no);
  static void perform(int success);
  static int  fuzzy_compare(double x, double y,
                            double tol = __TESTDFLT_TOL );
  static int  fuzzy_abs_compare(double x, double y,
				double tol = __TESTDFLT_TOL );

  static void summary(void);
  static int failed(void);
};

#define __TESTPFX(foo) Test::foo

#else
/* __cplusplus */

extern void Test_start(const char* name);
extern void Test_begin(const char* msg, size_t line_no);
extern void Test_perform(int success);
extern int  Test_fuzzy_compare(double x, double y, double tol );
extern int  Test_fuzzy_abs_compare(double x, double y, double tol );
extern int  fuzzy_compare(double x, double y );
extern int  fuzzy_abs_compare(double x, double y );
extern void Test_summary(void);
extern int Test_failed(void);

#define __TESTPFX(foo) Test_##foo

#endif
/* __cplusplus */

#else
/* CPLUSPLUSandC */

/* The testlib is to be installed as a C lib only */

#ifdef __cplusplus
extern "C" {
#endif

extern void Test_start(const char* name);
extern void Test_begin(const char* msg, size_t line_no);
extern void Test_perform(int success);
extern int  Test_fuzzy_compare(double x, double y, double tol );
extern int  Test_fuzzy_abs_compare(double x, double y, double tol );
extern int  fuzzy_compare(double x, double y );
extern int  fuzzy_abs_compare(double x, double y );
extern void Test_summary(void);
extern int  Test_failed(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#define __TESTPFX(foo) Test_##foo

#endif
/* CPLUSPLUSandC */

#define START(s) __TESTPFX(start)(s)

#define TEST_LINE(line,s,p,v)		\
  do {					\
    __TESTPFX(begin)(s, (size_t) line);	\
    __TESTPFX(perform)((p)==(v));	\
  } while(0)

#define TEST_PASS_LINE(line,s)		\
  do {					\
    __TESTPFX(begin)(s, (size_t) line);	\
    __TESTPFX(perform)(1);	\
  } while(0)

#define TEST_FAIL_LINE(line,s)		\
  do {					\
    __TESTPFX(begin)(s, (size_t) line);	\
    __TESTPFX(perform)(0);	\
  } while(0)

#define TEST_FP_LINE(line,s,p,v)					\
  do {									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_compare)((p),(v),__TESTDFLT_TOL) ); \
  } while(0)

#define TEST_FPABS_LINE(line,s,p,v)					\
  do {									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_abs_compare)((p),(v),__TESTDFLT_TOL) ); \
  } while(0)

#define TEST_FP_TOL_LINE(line,s,p,v,tol)				\
  do {									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_compare((p),(v),(tol))));	\
  } while(0)

#define TEST_FPABS_TOL_LINE(line,s,p,v,tol)				\
  do {									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_abs_compare((p),(v),(tol))));	\
  } while(0)

#define TEST_RUN_FP_LINE(line,s,x,p,v)					\
  do {									\
    x;									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_compare)((p),(v),__TESTDFLT_TOL)); \
  } while(0)

#define TEST_RUN_FPABS_LINE(line,s,x,p,v)					\
  do {									\
    x;									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_abs_compare)((p),(v),__TESTDFLT_TOL)); \
  } while(0)

#define TEST_RUN_FP_TOL_LINE(line,s,x,p,v,tol)				\
  do {									\
    x;									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_compare)((p),(v),tol));	\
  } while(0)

#define TEST_RUN_FPABS_TOL_LINE(line,s,x,p,v,tol)				\
  do {									\
    x;									\
    __TESTPFX(begin)(s, (size_t) line);					\
    __TESTPFX(perform)(! __TESTPFX(fuzzy_abs_compare)((p),(v),tol));	\
  } while(0)

#define TESTSTRING_LINE(line,s,p,v)			    \
  do {							    \
    __TESTPFX(begin)( s, (size_t) line );		    \
    __TESTPFX(perform)( !strcmp( (p), (v) ) );		    \
  } while (0);

#define TEST_RUN_LINE(line,s,x,p,v)		\
  do {						\
    x;						\
   __TESTPFX(begin)(s, (size_t) line);		\
   __TESTPFX(perform)((p)==(v));		\
  } while(0)



#ifdef TEST_OLD_STYLE

#define TEST(s,p,v)		TEST_LINE(__LINE__,s,p,v);
#define TEST_FP(s,p,v)		TEST_FP_LINE(__LINE__,s,p,v);
#define TEST_FP_TOL(s,p,v,tol)	TEST_FP_TOL_LINE(__LINE__,s,p,v,tol);
#define TEST_RUN_FP(s,x,p,v)	TEST_RUN_FP_LINE(__LINE__,s,x,p,v);
#define TEST_RUN_FP_TOL(s,x,p,v,tol)	TEST_RUN_FP_TOL_LINE(__LINE__,s,x,p,v,tol);
#define TESTSTRING(s,p,v)	TESTSTRING_LINE(__LINE__,s,p,v);
#define TEST_RUN(s,x,p,v)	TEST_RUN_LINE(__LINE__,s,x,p,v);

#else

#define TEST(s,p,v)		TEST_LINE(__LINE__,s,p,v)
#define TEST_PASS(s)		TEST_PASS_LINE(__LINE__,s)
#define TEST_FAIL(s)		TEST_FAIL_LINE(__LINE__,s)
#define TEST_FP(s,p,v)		TEST_FP_LINE(__LINE__,s,p,v)
#define TEST_FPABS(s,p,v)	TEST_FPABS_LINE(__LINE__,s,p,v)
#define TEST_FP_TOL(s,p,v,tol)	TEST_FP_TOL_LINE(__LINE__,s,p,v,tol)
#define TEST_FPABS_TOL(s,p,v,tol)	TEST_FPABS_TOL_LINE(__LINE__,s,p,v,tol)
#define TEST_RUN_FP(s,x,p,v)	TEST_RUN_FP_LINE(__LINE__,s,x,p,v)
#define TEST_RUN_FP_TOL(s,x,p,v,tol)	TEST_RUN_FP_TOL_LINE(__LINE__,s,x,p,v,tol)
#define TESTSTRING(s,p,v)	TESTSTRING_LINE(__LINE__,s,p,v)
#define TEST_RUN(s,x,p,v)	TEST_RUN_LINE(__LINE__,s,x,p,v)

#endif


#define SUMMARY() __TESTPFX(summary)()

#define FAILED() __TESTPFX(failed)()
 
#endif /* test_h_INCLUDED */
