// --8<--8<--8<--8<--
//
// Copyright (C) 2006 Smithsonian Astrophysical Observatory
//
// This file is part of BinaryPipe
//
// BinaryPipe is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// BinaryPipe is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the 
//       Free Software Foundation, Inc. 
//       51 Franklin Street, Fifth Floor
//       Boston, MA  02110-1301, USA
//
// -->8-->8-->8-->8--

#include <BinaryPipe/MyPhoton.h>

MyPhoton::MyPhoton( BPipe* bpipe, void* core ) throw ( BinaryPipeException ) {

  try {

    position = (DVector3*) dpktf_data( bpipe, core, BP_AXAF_phot_pos );

    direction = (DVector3*) dpktf_data( bpipe, core, BP_AXAF_phot_dir );

  } catch( BinaryPipeException& pfe ) {

    throw;

  }

}

/**
   simple routine to get the data pointer for a named data packet field 
*/
char* MyPhoton::dpktf_data( BPipe* bpipe, void* core, const char *name ) const 
  throw ( BinaryPipeException ) {

  DpktField *field = bpipe_dpktf( bpipe, (char*) name );
  if ( NULL == field ) {
    char msg[ 128 ];
    const char* format =
      "MyPhoton::dpktf_data( Bpipe*, %s ) : missing `%s' field\n";
    sprintf( msg, format, name, name );
    throw BinaryPipeException( msg );
  }

  return bpipe_dpktf_data( field, core );

}

void MyPhoton::print( std::ostream& os ) const {
  os.precision(14);
  os << position->x  << "\t" << position->y  << "\t" << position->z << "\t"
     << direction->x << "\t" << direction->y << "\t" << direction->z;
}
