// --8<--8<--8<--8<--
//
// Copyright (C) 2006 Smithsonian Astrophysical Observatory
//
// This file is part of RDB
//
// RDB is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// RDB is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the 
//       Free Software Foundation, Inc. 
//       51 Franklin Street, Fifth Floor
//       Boston, MA  02110-1301, USA
//
// -->8-->8-->8-->8--

#ifndef simpleRDBTable_cc
#define simpleRDBTable_cc

#include <rdbxx/simpleRDBTable.h>

template< class Type >
simpleRDBTable< Type >::~simpleRDBTable( ) {

  if ( rdb_column ) {
    delete [] rdb_column;
    rdb_column = NULL;
  }

}

template< class Type >
size_t simpleRDBTable< Type >::count_num_args( const char* str[] ) {

  size_t num = 0;
  for ( num = 0; NULL != str[ num ]; num++ )
    ;
  return num;

}

template< class Type >
simpleRDBTable< Type >::simpleRDBTable( const std::string& fname,
					const int mode,
					const char* header[] )
  :
  RDB( fname, static_cast<std::ios_base::openmode>(mode) ){

  /*
  The sun compiler doesn't seem to want to catch
  the exception thrown from the base class.
  */
    
    try {

      size_t num_cols = count_num_args( header );

      rdb_column = new RDBColumn*[ num_cols + 1 ];
      for( size_t ii = 0; ii < num_cols; ii++ ) {
	rdb_column[ ii ]= getColumn( header[ ii ] );
      }
      rdb_column[ num_cols ] = NULL;

      rdb_header = header;

    } catch( Exception& e ) {

      throw( e );

    } catch( ... ) {

      throw( Exception( "simpleRDBTable:  unexpected exception caught" ) );

    }
}

template< class Type >
void simpleRDBTable< Type >::getData( RDBColumn* rdbcol, std::string& val )
  {

    if ( NULL == rdbcol )
      throw Exception( "simpleRDBTable<T>::getData( RDBColumn*, std::string& ) :"
			  " The first argument must not be NULL\n" );

    rdbcol->getData( val );

}

template< class Type >
void simpleRDBTable< Type >::getData( RDBColumn* rdbcol, int& val )
  {

    if ( NULL == rdbcol )
      throw Exception( "simpleRDBTable<T>::getData( RDBColumn*, std::string& ) :"
			  " The first argument must not be NULL\n" );

    std::string tmp;
    rdbcol->getData( tmp );

    try {

      long result = suplib::str2l( tmp.c_str( ), 10 );
      val = (int) result;

    } catch( ... ) {

      throw;

    }

}

template< class Type >
void simpleRDBTable< Type >::getData( RDBColumn* rdbcol, long& val )
  {

    if ( NULL == rdbcol )
      throw Exception( "simpleRDBTable<T>::getData( RDBColumn*, std::string& ) : "
		       "The first argument must not be NULL\n" );

    std::string tmp;
    rdbcol->getData( tmp );

    try {

      val = suplib::str2l( tmp.c_str( ), 10 );

    } catch( ... ) {

      throw;

    }

}

template< class Type >
void simpleRDBTable< Type >::getData( RDBColumn* rdbcol, double& val )
  {

    if ( NULL == rdbcol )
      throw Exception( "simpleRDBTable<T>::getData( RDBColumn*, std::string& ) : "
		       "The first argument must not be NULL\n" );

    std::string tmp;
    rdbcol->getData( tmp );

    try {

      val = suplib::str2d( tmp.c_str( ) );

    } catch( ... ) {

      throw;

    }

}

template< class Type >
void simpleRDBTable< Type >::print( std::ostream& os ) const {

  if ( rdb_header ) {

    for( size_t num = 0; NULL != rdb_header[ num ]; num++ ) {
      os << rdb_header[ num ];
      if ( NULL != rdb_header[ num + 1 ] )
	os << '\t';
      else
	os << '\n';
    }

    for( size_t num = 0; NULL != rdb_column[ num ]; num++ ) {
      os << rdb_column[ num ]->getDef( );
      if ( NULL != rdb_column[ num + 1 ] )
	os << '\t';
    }

  }

}

template< class Type >
Type* simpleRDBTable< Type >::readRow( )
  {

  if ( ! _isptr )
      throw Exception( "The rdb table is not yet open for reading\n" );

    try {

      if ( read( ) )
	return new Type( rdb_header, rdb_column );
      else
	return (Type*) NULL;

    } catch( ... ) {

      throw;

    }

}

#endif
