* Revisions:
*     97-Feb-25 [D. Grumm]
*      . add clocking parameters (..2) for 2nd deformation
*      . add dfm2_scale for 2nd deformation parameter

*---  surface parameters...
* 
*     xbc        --  [1] x coordinate of surface center
*     ybc        --  [2] y coordinate of surface center
*     zbc        --  [3] z coordinate of surface center
*     srf_len    -- [10] surface length (x-ray)
*     srf_ro     -- [10] surface outer radius (conventional on-axis)
*     az_mis     --  [7] surface misalignment:  azimuth
*     el_mis     --  [8] surface misalignment:  elevation

      DOUBLE PRECISION  xbc, ybc, zbc, srf_len, srf_ro, az_mis, el_mis
      LOGICAL           is_xraysrf
      COMMON /srfstuff/ xbc, ybc, zbc, srf_len, srf_ro, az_mis, el_mis,
     &                  is_xraysrf
      SAVE   /srfstuff/

*---  clocking parameters...
* 
*     theta0     --      surface clocking angle (not a gi parameter)
*     costheta0  --      cos(theta0)
*     sintheta0  --      sin(theta0)
*     theta02     --     surface clocking angle (for 2nd deformation)
*     costheta02  --     cos(theta02)
*     sintheta02  --     sin(theta02)

      DOUBLE PRECISION  theta0, costheta0, sintheta0
      DOUBLE PRECISION  theta02, costheta02, sintheta02
      COMMON /clockstf/ theta0, costheta0, sintheta0, theta02,
     &                   costheta02, sintheta02
      SAVE   /clockstf/

*---  deformation amplitude...
* 
*     dfm_scale  --      rescale amplitude for 1st deformation
*     dfm2_scale  --      rescale amplitude for 2nd deformation

      INTEGER dfm_type
      LOGICAL found_dfm_type
      DOUBLE PRECISION  dfm_scale, dfm2_scale
      COMMON /dfm_stf/  dfm_scale, dfm2_scale, dfm_type, found_dfm_type
      SAVE   /dfm_stf/

