// -*-c++-*-
#ifndef SAOTRACE_IO_FITS_H
#define SAOTRACE_IO_FITS_H

#include <string>
#include <map>
#include <vector>
#include <iostream>
#include <algorithm>
#include <fitsio.h>

#include <Exception/Exception.h>


namespace SAOTrace {

    namespace IO {

	namespace FITS {


	    class Exception : public ::Exception {

	    public:
		Exception( const char* msg, const std::string& file, int status = 0 );

	    };

	    typedef std::vector<long> Extent;


	    template< typename T> struct ColumnType;

	    template <> struct ColumnType<double> 	  { static const int type = TDOUBLE; };
	    template <> struct ColumnType<float>  	  { static const int type = TFLOAT; };
	    template <> struct ColumnType<int>    	  { static const int type = TINT; };
	    template <> struct ColumnType<long>   	  { static const int type = TLONG; };
	    template <> struct ColumnType<short>  	  { static const int type = TSHORT; };
	    template <> struct ColumnType<unsigned int>   { static const int type = TUINT; };
	    template <> struct ColumnType<unsigned long>  { static const int type = TULONG; };
	    template <> struct ColumnType<unsigned short> { static const int type = TUSHORT; };


	    class ColumnBase {

	    public:

		virtual void insert( void* fitsdata, long nvalues ) = 0;
		virtual int type() = 0;
		virtual void reserve( long n ) = 0;

		ColumnBase( std::string& name ) : name(name) {}
		ColumnBase( const char*  name ) : name(name) {}
		ColumnBase( std::string& name, Extent extent ) : name(name), extent(extent) {}
		long repeat;
		long naxis;
		std::string name;
		Extent extent;
	    };

	    template <typename T>
	    class Column : public ColumnBase {

	    public:
		Column() { }

	        Column( std::string& name, std::vector<T>& data ) : ColumnBase( name ), data( data ) {}
	        Column( std::string& name, std::vector<T>& data, std::vector<ColumnBase*>& columns )
		    : ColumnBase( name ), data( data ) {

		    columns.push_back( this );
		}

	        Column( const char* name, std::vector<T>& data ) : ColumnBase( name ), data( data ) {}
	        Column( const char* name, std::vector<T>& data, std::vector<ColumnBase*>& columns )
		    : ColumnBase( name ), data( data ) {
		    columns.push_back( this );
		}

	        Column( std::string& name, std::vector<T>& data, Extent extent ) : ColumnBase( name, extent ), data( data ) {}
	        Column( std::string& name, std::vector<T>& data, Extent extent, std::vector<ColumnBase*>& columns )
		    : ColumnBase( name, extent ), data( data ) {

		    columns.push_back( this );
		}

		int type () { return _type ; }

		std::vector<T>& data;

		void reserve( long n ) { data.reserve(n); }

		void insert( void* fitsdata, long nvalues ) {

		    T* pdata = static_cast<T*>(fitsdata) + 1;

		    data.insert( data.end(), pdata, pdata + nvalues ) ;

		}

	    private:
		static const int _type = ColumnType<T>::type;

	    };


	    class TableFH {

	    public:
		TableFH ( const std::string& file, int iomode = READONLY );

		~TableFH() {

		    if ( fits_close_file( _fptr, &_status ) )
			throw( Exception( "error closing table", _file, _status ) );
		}

		long read_table_columns( std::vector<FITS::ColumnBase*>& columns );
		bool has_column( const char* colname );

	    private:
		std::string _file;
		int _status;
		fitsfile* _fptr;

	    };


	    bool cmp_shape( std::vector<long>& a0, std::vector<long>& b0 );

	    long read_table_columns(const std::string& file, std::vector<ColumnBase*>& columns);

	}

    }

}

#endif //! SAOTRACE_IO_FITS_H
