#ifndef SUPLIB_PP_STR_H
#define SUPLIB_PP_STR_H

// --8<--8<--8<--8<--
//
// Copyright (C) 2006 Smithsonian Astrophysical Observatory
//
// This file is part of suplibxx
//
// suplibxx is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// suplibxx is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the 
//       Free Software Foundation, Inc. 
//       51 Franklin Street, Fifth Floor
//       Boston, MA  02110-1301, USA
//
// -->8-->8-->8-->8--

#include <cstddef>
#include <cstdio>
#include <string>

#include <Exception/Exception.h>

namespace suplib { 
  
 std::string& trim( std::string& str );

 std::string& prune( std::string& str );

 bool iscomment( const std::string& str, const std::string& ignore=" \t", const std::string& comment="#" );
 
 float str2f( const char* txt );

 double str2d( const char* txt );

 int str2i( const char* txt, int base=10 );

 long str2l( const char* txt, int base=10 );

 unsigned long str2ul( const char* txt, int base=10 );

template <typename Container>
void tok (Container &container, std::string const &in,
	  const char * const delimiters = " \t\n",
	  bool skip=true
	  )
{
  const std::string::size_type len = in.length();
  std::string::size_type i = 0;
  std::string::size_type j = 0;

  if ( 0 == len )
    return;

  while ( len > i ) {

    if ( skip ) 
      i = in.find_first_not_of( delimiters, i );

    j = in.find_first_of( delimiters, i );

    if ( std::string::npos == i ) {

      return;

    } else if ( std::string::npos == j ) {
      
      container.push_back( in.substr( i,  j ) );
      return;
      
    } else {

      container.push_back( in.substr( i, j - i ) );
      
    }
    
    i = skip ? j : j + 1;
    
  }

  container.push_back( std::string() );
  /*
  const std::string::size_type len = in.length();
          std::string::size_type i = 0;

    while ( i < len )
    {
        if ( skip ) {
            // eat leading whitespace
            i = in.find_first_not_of (delimiters, i);
            if (i == std::string::npos)
                return;   // nothing left but white space
        }
	
        // find the end of the token
        std::string::size_type j = in.find_first_of (delimiters, i);

        // push token
        if (j == std::string::npos) {
            container.push_back (in.substr(i));
            return;
        } else
            container.push_back (in.substr(i, j-i));

        // set up for next loop
        i = j + 1;
    }
  */
 }
}

#endif // ! SUPLIB_PP_STR_H
