############################################################################
# 
#  Copyright (C) 2008-2009,2011  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: setup_sherpa.csh.in
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the user environment obsvis.
#
#       This version of the script is written in the Bourne shell language,
#       but is compatible with ksh and bash, too.
#
############################################################################

# if we are not being called by ciao.sh setup the ciao.sh stuff

if ( "$?ASCDS_CIAO" ) then
   if ( "$ASCDS_CIAO" != "ciao" ) then
        setenv ASCDS_CIAO "standalone"
	source /opt/conda/envs/ciao-4.17.0/bin/ciao.csh
   endif
else
   setenv ASCDS_CIAO "standalone"
   source /opt/conda/envs/ciao-4.17.0/bin/ciao.csh
endif

# setup package variables

################################################################
#                       HEADAS Setup                           #
################################################################

if ( -d /opt/conda/envs/ciao-4.17.0/spectral ) then
    setenv CIAO_HEADAS /opt/conda/envs/ciao-4.17.0/spectral
endif

setenv XSPEC_HELP_FILE /opt/conda/envs/ciao-4.17.0/doc/xspec.hlp
