set(CIAO_VERSION 4.17.0)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was CiaoConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(CIAO_BINARIES        "${PACKAGE_PREFIX_DIR}/bin")
set_and_check(CIAO_LIBRARIES       "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(CIAO_INCLUDE_DIR     "${PACKAGE_PREFIX_DIR}/include")
set_and_check(CIAO_PARAM_DIR       "${PACKAGE_PREFIX_DIR}/param")
set_and_check(CIAO_DOC_DIR         "${PACKAGE_PREFIX_DIR}/share/doc")
set_and_check(CIAO_XML_DIR         "${PACKAGE_PREFIX_DIR}/share/doc/xml")
set_and_check(CIAO_TEST_DIR        "${PACKAGE_PREFIX_DIR}/test")
set_and_check(CIAO_TEST_BIN        "${PACKAGE_PREFIX_DIR}/test/bin")
set_and_check(CIAO_TEST_SMOKE      "${PACKAGE_PREFIX_DIR}/test/smoke")

# include the segments of CIAO. This may fail if we don't ship all the segments... FIXME
include(${CIAO_LIBRARIES}/cmake/ciao/CorelibsConfig.cmake)
include(${CIAO_LIBRARIES}/cmake/ciao/CiaolibsConfig.cmake)
#include(CiaotoolsConfig.cmake)
