def process_results(results):
    csc_obs_id_set = set()
    csc_stack_detect_id_set = set()
    archival_obs_id_set = set()
    warning_ids_set = set()

    for file_path, data in results.items():
        ds_ident = data.get('DS_IDENT')

        if ds_ident:
            if ds_ident.startswith('10.25574/csc2.obs'):
                # Extract the ID after the prefix and add it to the CSC ObsID set
                obs_id_part = ds_ident.split('.')[-1]
                csc_obs_id_set.add(obs_id_part)
            elif ds_ident.startswith('10.25574/csc2.stk'):
                # Extract the ID for stack detect and add it to the CSC Stack Detect ID set
                stack_id_part = ds_ident.split('.')[-1]
                csc_stack_detect_id_set.add(stack_id_part)
            elif ds_ident.startswith('10.25574/'):
                # Handle the general archival ID case
                archival_id_part = ds_ident.split('/')[-1]
                archival_obs_id_set.add(archival_id_part)
            else:
                # If DS_IDENT is not a DOI, add it to a list of warnings
                warning_ids_set.add(ds_ident)

    return {
        "CSC ObsID": csc_obs_id_set,
        "CSC Stack Detect ID": csc_stack_detect_id_set,
        "Archival ObsID": archival_obs_id_set,
        "Warning - These IDs are not DOIs": warning_ids_set
    }
