from concurrent.futures import Executor, Future


class SerialExecutor(Executor):
    """
    A simple executor implementation that runs tasks synchronously for testing purposes.
    """
    def __init__(self, total, report_function=None):
        self.total = total
        self.completed = 0
        self.report_function = report_function

    def submit(self, fn, *args, **kwargs):
        future = Future()
        try:
            result = fn(*args, **kwargs)
            future.set_result(result)
        except Exception as e:
            future.set_exception(e)
        finally:
            self.completed += 1
        if self.report_function is not None:
            self.report_function(self.completed, self.total)
        return future

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        pass
