# 
#  Copyright (C) 2010-2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

"""

Python Crates API.

"""
import sys
import cxcdm as dm
from numpy import array
 
import pycrates.io as io

from pycrates.cratekey import *
from pycrates.cratedata import *
from pycrates.crate import *
from pycrates.tablecrate import *
from pycrates.imagecrate import *

from pycrates.cratedataset import *
from pycrates.rmfcratedataset import *
from pycrates.phacratedataset import *

from pycrates.hlui import *

from pycrates.cratesubspacedata import *
from pycrates.cratesubspace import *

from pycrates.crateutils import *

# ciao version
try:
    import ciao_version
    vstr = ciao_version.get_ciao_version()
except ImportError:
    print("Warning: Unable to load the ciao_version module to determine version number- defaulting 'pycrates' version to 0.0.0");
    vstr = "0.0.0"

__version__ = vstr

__all__ = ["CrateDataset",
           "RMFCrateDataset",
           "PHACrateDataset",
           "Crate",
           "TABLECrate",
           "IMAGECrate",
           "CrateData",
           "CrateKey",
           "CrateSubspaceData",
           "CrateSubspace",
           "REGULAR", "VIRTUAL"
           ]

__all__.extend(hlui.__all__)

__all__.extend(crateutils.__all__)


