class CrateIO:
    def __init__(self):
        if self.__class__ == CrateIO:
            raise NotImplementedError("Cannot create a CrateIO object.")

        self.name   = ""
        self.__fptr = None  # points to dmDataset


    def __clear__(self):
        # public attributes
        self.name  = "" 


    def __del__(self):
        return None


    def canHandle(self, obj):
        """
           Check if the input object is of a type that the class
           is capable of processing.

           Returns boolean
        """
        raise NotImplementedError("canHandle() not implemented")

    def load( self, obj, input=None ):
        """
          Load values of input Crate object.
          obj = {CrateDataset, TABLECrate, IMAGECrate }
        """
        raise NotImplementedError("load() not implemented")

    def open(self, input, mode):
        """
          Open provided object and set fptr attribute.
        """
        raise NotImplementedError("open() not implemented")

    def read_header(self, blockno):
        """
          Extract header info from fptr attribute, create and return
          a List of CrateKey objects
        """
        raise NotImplementedError("read_header() not implemented")
        
    def read_columns(self, blockno):
        """
          Extract column info from fptr attribute, create and return
          a List of CrateData objects
        """
        raise NotImplementedError("read_columns() not implemented")

    def read_image(self):
        """
          Extract Image info from fptr attribute, create and return
          a CrateData object
        """
        raise NotImplementedError("read_image() not implemented")

    def close(self):
        """
          Close object at fptr attribute.
        """
        raise NotImplementedError("close() not implemented")

    def create(self):
        """
          Create a new object and set fptr attribute.
        """
        raise NotImplementedError("create() not implemented")

    def write_header(self, blockno, keylist):
        """
          Write all CrateKey data to object at fptr,
          may obtain CrateKey list from Crate object.
        """
        raise NotImplementedError("write_header() not implemented")

    def write_key(self, key, blockno):
        """
          Write individual CrateKey data to object at fptr,
        """
        raise NotImplementedError("write_key() not implemented")

    def write_column(self):
        """
          Write individual CrateData to object at fptr,
        """
        raise NotImplementedError("write_column() not implemented")

    def write_image(self):
        """
          Write individual  CrateData to object at fptr,
        """
        raise NotImplementedError("write_image() not implemented")

    
