#!/opt/conda/envs/ciao-4.17.0/bin/python3
# 
#  Copyright (C) 2007,2012,2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

from __future__ import print_function

from pytransform import *
from numpy import array
import numpy
from os import environ

#  Setup input/output directories
#
testin  = environ.get('TESTIN')
if testin == None :
  indir = environ.get('PWD')
else :
  indir = testin + '/test_transform'

testout = environ.get('TESTOUT')
if testout == None :
  outdir = environ.get('PWD')
else :
  outdir = testout + '/transform'

print("\n************************************************************")
print("              Transform TransParam Class                     ")
print("************************************************************")
#
# Wrapped and running
#   TransParam() 
#   string get_name();
#   void*  get_value();
#   string get_desc();
#   string get_parent();
#   long   get_nvals();
#
#   void   set_value(bool* in_value);
#   void   set_value(long* in_value);
#   void   set_value(double* in_value);
#   void   set_value(string* in_value);
#   void   clear();
#   string show();
#
# Added to Python
#   void   set( name, value(s), description )
#
# ToDo
#   None
#
# Ignore in Python..
#   TransParam(string in_name, void* in_value, dmDataType in_datatype,
# 	    string in_desc, string in_parent, long nvals);
#   void   set_value(void* in_value, dmDataType in_datatype);
#   void   set_value(short* in_value);
#   void   set_value(float* in_value);
#   void   set_value(unsigned short* in_value);
#   void   set_value(unsigned long* in_value);
#   void   set_value(unsigned char* in_value);
# 
#   void   set_name(string in_name);
#   void   set_desc(string in_desc);
#   void   set_parent(string in_parent);


# ----------------------------------------------------------------------

print("\nCreate Transform Parameter object...")
myParam =  TransParam()
print(" myParam = TransParam() \n")

print("\nDisplay with defaults.")
print(" myParam.show()")
print(myParam.show())

print("\nCreate Transform Parameter object... with content")
print(" myParam = TransParam('FOC_LEN', 10061.620000000, 'HRMA focal length (mm)')")
dval = array(10061.620000000, dtype=numpy.double)
myParam = TransParam("FOC_LEN", dval, "HRMA focal length (mm)")

print("\nDisplay number of values contained.")
print(" myParam.get_nvals() => ", myParam.get_nvals())

print("\nDisplay with set values.")
print(myParam.show())

print("\nClear these values.")
print(" myParam.clear()")
myParam.clear()

print("\nDisplay with cleared values.")
print(myParam.show())

# ----------------------------------------------------------------------

#setup data values for Parameters
sval = int(7)
lval = 123456
rval = float(44.0125)
dval = 123.456
cval = "BLAH"
bval = True

# Null valued parameter
nParam = TransParam()

print("\nDefine Parameter of each Type")

print("Short... sval type = ", type(sval).__name__)
sParam = TransParam("SPARAM", sval, "Short parameter")
print(sParam.show())

print("Long... lval type = ", type(lval).__name__)
lParam = TransParam("LPARAM", lval, "Long parameter")
print(lParam.show())

print("Float... rval type = ", type(rval).__name__)
fParam = TransParam("FPARAM", rval, "Float parameter")
print(fParam.show())

print("Double... dval type = ", type(dval).__name__)
dParam = TransParam("DPARAM", dval, "Double parameter")
print(dParam.show())

print("Boolean... bval type = ", type(bval).__name__)
bParam = TransParam("BPARAM", bval , "Boolean parameter")
print(bParam.show())

print("String... cval type = ", type(cval).__name__)
cParam = TransParam("CPARAM", cval , "String parameter")
print(cParam.show())

# ----------------------------------------------------------------------
# Modify Data values..
print("\nModify parameter value for each type")
newval = -5551212.999
print("   newval = ", newval , " dtype = ", type(newval).__name__)
print("   param.set_value(newval)")

print("Short... ")
sParam.set_value( newval );
print(sParam.show())

print("Long...")
lParam.set_value( newval )
print(lParam.show())

print("Float...")
fParam.set_value( newval )
print(fParam.show())

print("Double...")
dParam.set_value( newval )
print(dParam.show())

print("String...")
cParam.set_value( "Gargoyle" )
print(cParam.show())


# ----------------------------------------------------------------------

# Set Parent field for each Parameter
print("\nSet Parent field for each Parameter")
print(" <t>Param.set_parent('MyTrans')")
sParam.set_parent("MyTrans")
lParam.set_parent("MyTrans")
fParam.set_parent("MyTrans")
dParam.set_parent("MyTrans")
bParam.set_parent("MyTrans")
cParam.set_parent("MyTrans")

# ----------------------------------------------------------------------

print("\nObtain and show Parameter info manually")
print("Short...")
name = sParam.get_name()
desc = sParam.get_desc()
pnam = sParam.get_parent()
sval = sParam.get_value()
print("Name:", name, "  Value:", sval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("sval type = ", type(sval).__name__)

print("Long...")
name = lParam.get_name()
desc = lParam.get_desc()
pnam = lParam.get_parent()
lval = lParam.get_value()
print("Name:", name, "  Value:", lval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("lval type = ", type(lval).__name__)

print("Float...")
name = fParam.get_name()
desc = fParam.get_desc()
pnam = fParam.get_parent()
rval = fParam.get_value()
print("Name:", name, "  Value:", rval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("rval type = ", type(rval).__name__)

print("Double...")
name = dParam.get_name()
desc = dParam.get_desc()
pnam = dParam.get_parent()
dval = dParam.get_value()
print("Name:", name, "  Value:", dval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("dval type = ", type(dval).__name__)

print("Boolean...")
name = bParam.get_name()
desc = bParam.get_desc()
pnam = bParam.get_parent()
bval = bParam.get_value()
print("Name:", name, "  Value:", bval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("bval type = ", type(bval).__name__)

print("String...")
name = cParam.get_name()
desc = cParam.get_desc()
pnam = cParam.get_parent()
cval = cParam.get_value()
print("Name:", name, "  Value:", cval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("cval type = ", type(cval).__name__)

print("Null...")
name = nParam.get_name()
desc = nParam.get_desc()
pnam = nParam.get_parent()
nval = nParam.get_value()
print("Name:", name, "  Value:", nval, "  Desc:\'", desc, "\'  Parent:",pnam)
print("cval type = ", type(nval).__name__)

# ----------------------------------------------------------------------
print("\nDefine Multi-valued Parameter")
vParam = TransParam("CRVAL", [123.0,456.0], "Reference Value")
print("  vParam.show()...")
print(vParam.show())
print("  - Extract individual fields and display")
name = vParam.get_name()
desc = vParam.get_desc()
pnam = vParam.get_parent()
vval = vParam.get_value()
print("    Name:", name)
print("    Value:", vval)
print("    Desc:\'", desc, "\'")
print("    Parent:",pnam)
print("    vval type = ", type(vval).__name__)


print("\nDefine Multi-valued String Parameter")
vParam = TransParam("CTYPE", ["RA---TAN","DEC--TAN"], "Projection Type")
print("  vParam.show()...")
print(vParam.show())
print("  - Extract individual fields and display")
name = vParam.get_name()
desc = vParam.get_desc()
pnam = vParam.get_parent()
vval = vParam.get_value()
print("    Name:", name)
print("    Value:", vval)
print("    Desc:\'", desc, "\'")
print("    Parent:",pnam)
print("    vval type = ", type(vval).__name__)
print("  - Modify values and display")
vParam.set_value( ["THETATAN","PHI--TAN"] )
name = vParam.get_name()
desc = vParam.get_desc()
pnam = vParam.get_parent()
vval = vParam.get_value()
print("    Name:", name)
print("    Value:", vval)
print("    Desc:\'", desc, "\'")
print("    Parent:",pnam)
print("    vval type = ", type(vval).__name__)

# ----------------------------------------------------------------------
print("\nDone!\n")
