local coords     = require( 'chandra.saotrace.coords' )
local spec_utils = require( 'saotrace.raygen.spectrum.utils' )
local raygen     = require( 'saotrace.raygen' )
local position   = require('chandra.saotrace.raygen.sources.position')
local tables     = require('saotrace.suplib.tables' )
local source     = require( 'chandra.saotrace.raygen.source' )
local ea         = require('saotrace.raygen.ea.create_from_db')

local require    = require
local assert     = assert

-- sanitize arguments sent to
-- saotrace.raygen.ea.create_from_db.entrance_aperture args may be an
-- environment returned by boxing a load of a file or string, so may
-- have trigger an "unexpected elements" validation error

local function ea_wrap( args )

   return ea.entrance_aperture( tables.filter_matched_keys( ea.vspec, args ) )

end


local config = require( 'saotrace.config' ).raygen
config.scripts.sources.func = source.default

-- trace-shell needs to provide the shell & db parameters
-- in config.scripts.entrance_aperture.args
config.scripts.entrance_aperture.func = ea_wrap

return { sources = sources }
