-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.aperture
--
-- saotrace.aperture is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

--- mock aperture functions

local package = package

local _stack = {}

function _reset_stack ()

   _stack = {}

end


function _get_stack ()
   return _stack
end

local export = {
   _reset_stack = _reset_stack,
   _get_stack   = _get_stack
}


setmetatable( export,
	      { __index = function(t,k)
			     return function(...)
				       table.insert( _stack, { k, ... } )
				    end
			  end
	     }
	   )
package.loaded['saotrace.aperture'] = export
return export
