-- jitter generator call validation

local raygen = require( 'saotrace.raygen' )
local vobj = require('saotrace.raygen.validate').vobj

local _M = {}


--------------------------
-- this holds the validation specifications for the generators.  it
-- cannot be local because intrinsic uses it to create mock functions

_M.vspec = {}
local vspec = _M.vspec

--------------------------

local aparam = {
   phase  = { type = 'angle_radian', default = 0 },
   amp    = { type = 'angle_arcsecond'},
   period = { type = 'time'},
}

vspec.lissajous = {
   name = { type = 'string' },
   pitch = { vtable = aparam },
   yaw   = { vtable = aparam },
}

--------------------------

vspec.file = {
   name = { type = 'string' },
   file = { type = 'string' },

   ['%one_of'] = { {'quat_col', 'axes'} },

   quat_col  = { type = 'string',
		 optional = true,
	      },

   axes = { multiple = { n = 3 },
	    type = { ['rotation axis'] = {
			vtable = {
			   col       = { type = 'string' },
			   axis      = { type = 'axis'  },
			   scale     = { type = 'number',  optional = true },
			   autoscale = { type = 'boolean', default = true  },
			},
		     }
		  },
	    optional = true,
	 },

   format = {
      enum = { 'auto', 'fits' },
      default = 'auto'
   },

   rotation_is_additive = {
      type = 'boolean',
      default = false
   },

   time_col  = { type = 'string', default = 'time'  },

   optical_axis = { type = 'axisangle',
		    multiple = true,
		    optional = true,
		 },

   coord_xfrm = {
      optional = true,
      vtable = {
	 x = { type = 'axis', default = { 1, 0, 0 } },
	 y = { type = 'axis', default = { 0, 1, 0 } },
	 z = { type = 'axis', default = { 0, 0, 1 } },
      }
   },

   input_origin = { type = 'axisangle',
		    multiple = true,
		    optional = true,
		 },

   extrapolate_max_dt = { type = 'number', default = 0 },

}

vspec.roll = {
   { name = 'roll', type = 'angle_degree' },
}


---------------------------

-- create wrappers around compiled functions

local intrinsic = require( 'saotrace.raygen.intrinsic.jitter' )

for gen, specs in pairs( vspec ) do

   _M[gen] =  function (...)
		 local ok, args = vobj:validate( specs, ... )
		 if ok then
		    return intrinsic[gen](args)
	     else
		return error( args, 2 )
	     end
	  end
end

return _M
