-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.suplib
--
-- saotrace.suplib is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local setmetatable = setmetatable
local setfenv      = setfenv
local assert       = assert
local type         = type
local loadstring   = loadstring
local loadfile     = loadfile
local require      = require

local paths        = require( 'saotrace.suplib.paths' )

module( ... )

-- two-layer sandbox of a function. returns environment
function sandbox2( env, func, ... )

   local senv = {}
   setmetatable( senv, { __index = env } )
   setfenv( func, senv )
   return senv, func( ... )

end

-- two-layer sandbox of a require
function sandbox2_require( env, mod )

   return sandbox2( env, function() return require( mod ) end )

end

-- one-layer sandbox of a function. returns environment
function sandbox( env, func, ... )

   setfenv( func, env )

   return env, func( ... )
end


---
-- one or two-layer sandbox of something

function boxit( env, thing, two_layer, ... )

   local sndbox = two_layer and sandbox2 or sandbox

   if type(thing) == 'function' then

      return sndbox( env, thing, ... )

   end

   assert( type(thing) == 'string' )


   -- if it ends in .lua it's a lua script, dofile it
   if thing:find( '%.lua$' ) then

      return sndbox( env, assert( loadfile( thing ) ), ... )

   -- if it's a module name, require it
   elseif paths.is_modname( thing ) then

      return sndbox( env, function() return require( thing ) end, ... )

   -- treat it as a string, dostring it
   else

      return sndbox( env, assert( loadstring( thing ) ), ... )

   end

   assert( false )

end
