.\" Automatically generated by Pod::Man 4.10 (Pod::Simple 3.35)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "bp2fits l"
.TH bp2fits l "2020-09-28" " " " "
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
bp2fits \- Converts bpipe format data to FITS format data.
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBbp2fits\fR [\fIparameter\fR=\fIvalue\fR] [bp_dpktf_name=fits_bintable_col_name]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBbp2fits\fR converts \fBbpipe\fR format data to \s-1FITS\s0 format data.  As
input, it takes a \fBbpipe\fR file(\fBinput\fR) to convert and an \s-1RDB\s0
file(\fBtrans\fR) that, among other things, provides a mapping between
\&\fBbpipe\fR data packet field (dpktf) names and the \s-1FITS\s0 binary table
column names.  It outputs a \s-1FITS\s0 file containing a primary header data
unit(\s-1PHDU\s0), an additional header data unit(\s-1HDU\s0), and a binary table.
The \s-1PHDU\s0 contains cards coming from the \s-1RDB\s0 \fBtrans\fR file.  The \s-1HDU\s0
contains cards coming from the \s-1RDB\s0 \fBtrans\fR file as well as the
\&\fBbpipe\fR header data field(hdrf).
.SH "OPTIONS AND ARGUMENTS"
.IX Header "OPTIONS AND ARGUMENTS"
\&\fBbp2fits\fR uses an \s-1IRAF\s0 param style parameter interface.
.PP
The parameters are :
.IP "\fBinput\fR" 4
.IX Item "input"
The \fBbpipe\fR input stream/file.  Set equal to \f(CW\*(C`stdin\*(C'\fR to read from the \s-1UNIX\s0
standard input stream.
.IP "\fBoutput\fR" 4
.IX Item "output"
The \s-1FITS\s0 output stream/file.  Set equal to \f(CW\*(C`stdout\*(C'\fR to write to the
\&\s-1UNIX\s0 standard output stream.
.IP "\fBadd_exact_dpktfs\fR" 4
.IX Item "add_exact_dpktfs"
Comma seperated list of \fBbpipe\fR data packet fields to add to the
output \s-1FITS\s0 table.  See \*(L"\s-1SELECTING FIELDS\*(R"\s0 for further info.
.IP "\fBadd_regex_dpktfs\fR" 4
.IX Item "add_regex_dpktfs"
Comma seperated list of regular expression to match against \fBbpipe\fR data
packet fields.  Matches are added to the output \s-1FITS\s0 table.  See
\&\*(L"\s-1SELECTING FIELDS\*(R"\s0 for further info.
.IP "\fBdel_exact_dpktfs\fR" 4
.IX Item "del_exact_dpktfs"
Comma seperated list of \fBbpipe\fR data packet fields to delete from the
output \s-1FITS\s0 table.  See \*(L"\s-1SELECTING FIELDS\*(R"\s0 for further info.
.IP "\fBdel_regex_dpktfs\fR" 4
.IX Item "del_regex_dpktfs"
Comma seperated list of regular expressions to match against \fBbpipe\fR
data packet fields.  Matches are removed from the output \s-1FITS\s0 table.
See \*(L"\s-1SELECTING FIELDS\*(R"\s0 for further info.
.IP "\fBtrans\fR" 4
.IX Item "trans"
The file describing how to translate the \fBbpipe\fR data into \s-1FITS.\s0  This
is used to massage the \s-1FITS\s0 into formats required by other programs.
.Sp
If this is set to the string \f(CW\*(C`default\*(C'\fR, a wholly adequate default
transformation is performed.
.IP "\fBlongstrn\fR" 4
.IX Item "longstrn"
If set to yes, use the \s-1HEASARC OGIP\s0 Long String Keyword Convention.
See http://heasarc.gsfc.nasa.gov/docs/heasarc/ofwg/docs/ofwg_recomm/r13.html
.IP "\fBreserved\fR" 4
.IX Item "reserved"
If set to yes, output various \s-1FITS\s0 reserved keywords to the \s-1HDU.\s0  See
\&\*(L"Automatically Generated Keyword Values\*(R" for more details.
.IP "\fBdoublepass\fR" 4
.IX Item "doublepass"
If set to yes and \fBreserved\fR is set to yes, write the \fBbpipe\fR once
to determine values for \s-1TDMIN\s0 and \s-1TDMAX\s0 keywords from the data, then
seek through and update the pertinient keywords.  See \*(L"Automatically
Generated Keyword Values\*(R" for more details.
.IP "\fBvectors\fR" 4
.IX Item "vectors"
If set to yes, represent \fBbpipe\fR vector data types as a single column
in the \s-1FITS\s0 table.  Otherwise, split each element of the vector into a
separate column.
.IP "\fBhelp\fR" 4
.IX Item "help"
If true, it causes a brief synopsis of options to be written out.
.IP "\fBusage\fR" 4
.IX Item "usage"
If true, it causes a extended explanation of \fBbp2fits\fR to be written out.
.IP "\fBverbose\fR" 4
.IX Item "verbose"
Level of debugging messages to be displayed.
.IP "\fBversion\fR" 4
.IX Item "version"
If true, then the version number of the  program will be written out
and the program will exit.
.SH "OVERVIEW"
.IX Header "OVERVIEW"
\&\fBbp2fits\fR converts a binary pipe format file (\fBbpipe\fR) to a \s-1FITS\s0 format file.
.PP
There are two distinct data structures in a a binary pipe format file,
the header data field (hdrf) and the data packet field (dpktf).
\&\fBbp2fits\fR attempts to create a one to one mapping between \fBbpipe\fR
header fields and \s-1FITS HDU\s0 cards, as well as, between \fBbpipe\fR data
packet fields and \s-1FITS\s0 binary table columns.  By default, \fBbp2fits\fR
will attempt to translate each hdrf and each dpktf in the input
\&\fBbpipe\fR to a card and column, respectively, in the output \s-1FITS\s0 file.
The user may modify the default translation or add keywords the the
\&\s-1FITS\s0 header by specifying translation rules in the \fBtrans\fR file, see
\&\*(L"Trans File\*(R" for further info.
.PP
In general, the \s-1FITS\s0 standard is more restrictive with respect to the
dimensionality of the data and the number of characters allowed to
express values or field names.  With this in mind, \fBbp2fits\fR will use
the unmodified \fBbpipe\fR value or name where possible and will truncate
the value or name where necessary.  Setting the \fBverbose\fR flag will
cause \fBbp2fits\fR to print warnings about many of the truncations and
imperfect \fBbpipe\fR to \s-1FITS\s0 translations.
.SH "SELECTING FIELDS"
.IX Header "SELECTING FIELDS"
Four parameters control which \fBbpipe\fR data packet fields are passed
on to the output \s-1FITS\s0 table.
.IP "\fBadd_exact_dpktf\fR" 4
.IX Item "add_exact_dpktf"
.PD 0
.IP "\fBadd_regex_dpktf\fR" 4
.IX Item "add_regex_dpktf"
.IP "\fBdel_exact_dpktf\fR" 4
.IX Item "del_exact_dpktf"
.IP "\fBdel_regex_dpktf\fR" 4
.IX Item "del_regex_dpktf"
.PD
.PP
If all four parameters are blank, all data packet fields are passed on
to the output table.  If one or both of the add_* fields are
specified, a list of output columns is constructed based on the data
packet fields which match the add_ list.  Alternatively, if neither
add_* field is specified, all input data packet fields are place in
the add_ list.
.PP
If one or both of the del_* fields are specified, matches are removed
from the add_ list.
.PP
Only the data packet fields remaining in the add_ list after this
process are written to output.
.SH "CONVERTING BPIPE TO FITS"
.IX Header "CONVERTING BPIPE TO FITS"
.SS "Header Fields"
.IX Subsection "Header Fields"
\&\fBbpipe\fR header fields are named fields, possibly of multiple
dimensions, of various data types.  They correspond, roughly, to \s-1FITS
HDU\s0 cards.  As with \s-1FITS\s0 cards, there may be multiple header fields
with the same name.  Currently, each hdrf with the same name
overwrites the previous hdrf when translating to \s-1FITS\s0 cards.  Note,
this does not apply to \s-1COMMENT\s0 or \s-1HISTORY\s0 keywords handed in through
the \fBtrans\fR \s-1RDB\s0 file.
.PP
There are a number of ways in which the two formats differ.  Unlike
\&\s-1FITS\s0 card keywords, \fBbpipe\fR hdrf names are not restricted to
character strings of length less than or equal to 8 characters.
Another issue in converting \fBbpipe\fR to \s-1FITS\s0 is that \fBbpipe\fR header
fields may be multidimensional and \s-1FITS\s0 cards are always
scalars. Finally, all possible \fBbpipe\fR hdrf data types do not map
directly to \s-1FITS\s0 card value data types.
.PP
\fIConverting Header Field Names\fR
.IX Subsection "Converting Header Field Names"
.PP
As \fBbpipe\fR hdrf names are not restricted to the 8 characters that \s-1FITS\s0
card keywords are, we will outline the process where by \fBbp2fits\fR
converts \fBbpipe\fR hdrf names to \s-1FITS HDU\s0 keywords.
.IP "\(bu" 4
Any \s-1RDB\s0 header variables in the \fBtrans\fR file are processed first.
.IP "\(bu" 4
If a name is less than or equal to 8 characters long, it is used as
is.
.IP "\(bu" 4
If a name is greater than 8 characters long, the name is
truncated so that the truncated name is 8
characters.
.IP "\(bu" 4
If a truncated name collides with an existing name or another
previously truncated name, it overwrites the previous name and value.
.PP
\fIConverting Header Field Data\fR
.IX Subsection "Converting Header Field Data"
.PP
The \s-1FITS\s0 standard allows for \s-1HDU\s0 cards to store the following data
types: character string, logical, integer, floating point, complex
integer, and complex floating point.  This represents only a subset of
the data types allowed in \fBbpipe\fR header fields.  Below we list the
allowed \fBbpipe\fR data types, and either the corresponding \s-1FITS\s0 card
data type or a lack there of.
.IP "\fBchar\fR \fICharacter String\fR" 4
.IX Item "char Character String"
70 characters of \s-1ASCII\s0 text.
.IP "\fBdouble\fR \fIFloating Point Number\fR" 4
.IX Item "double Floating Point Number"
Represented by as many as 20 characters.
.IP "\fBint\fR \fIInteger Number\fR" 4
.IX Item "int Integer Number"
Represented by as many as 20 characters.
.IP "\fBuint\fR \fIInteger Number\fR" 4
.IX Item "uint Integer Number"
Represented by as many as 20 characters.
.IP "\fBDVector2\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "DVector2 No FITS Type"
First element is represented as a \fIFloating Point Number\fR.
.IP "\fBDVector3\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "DVector3 No FITS Type"
First element is represented as a \fIFloating Point Number\fR.
.IP "\fBIVector2\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "IVector2 No FITS Type"
First element is represented as a \fIInteger Number\fR.
.IP "\fBIVector3\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "IVector3 No FITS Type"
First element is represented as a \fIInteger Number\fR.
.IP "\fBUIVector2\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "UIVector2 No FITS Type"
First element is represented as a \fIInteger Number\fR.
.IP "\fBUIVector3\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "UIVector3 No FITS Type"
First element is represented as a \fIInteger Number\fR.
.IP "\fBDComplex\fR \fIComplex Floating Point Number\fR" 4
.IX Item "DComplex Complex Floating Point Number"
First element is represented as a \fIFloating Point Number\fR.
.IP "\fBDCVector2\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "DCVector2 No FITS Type"
First element is represented as a \fIFloating Point Number\fR.
.IP "\fBDCVector3\fR \fINo \s-1FITS\s0 Type\fR" 4
.IX Item "DCVector3 No FITS Type"
First element is represented as a \fIFloating Point Number\fR.
.PP
In the cases where there is no analogous \s-1FITS\s0 type, \fBbp2fits\fR will
warn the user if the \fBverbose\fR flag is set.
.PP
As \fBbpipe\fR header fields may be multidimensional and \s-1FITS\s0 cards are always
scalars, \fBbp2fits\fR will copy the first element of a hdrf if possible
and if the \fBverbose\fR flag is set, it will warn the user about the
remaining elements.
.SS "Data Packet Fields"
.IX Subsection "Data Packet Fields"
\&\fBbpipe\fR data packet fields are named fields, possibly of multiple
dimensions, of various data types.  They correspond roughly to columns
in \s-1FITS\s0 binary tables.  As with \s-1FITS\s0 binary tables, a \fBbpipe\fR data
packet contains fields with unique names.  Unlike \s-1FITS\s0 binary column
names, \fBbpipe\fR dpktf names have no length restriction.  Also, all
possible \fBbpipe\fR dpktf data types do not map directly to \s-1FITS\s0 binary
table column data types.
.PP
\fIConverting Data Field Names\fR
.IX Subsection "Converting Data Field Names"
.PP
The \s-1FITS\s0 standard restricts the length of binary table column names to
70 characters.  Since there is no such restriction placed on \fBbpipe\fR
dpktf names, \fBbp2fits\fR must handle names that are too long.
.IP "\(bu" 4
Names which appear in the \fBtrans\fR file are assigned the \fIfitsfield\fR
value given there.
.IP "\(bu" 4
Names which are less than or equal to 70 characters are used as is.
.IP "\(bu" 4
Names which are greater than 70 characters are truncated.
.IP "\(bu" 4
Names applied to vector data types
.PP
\fIConverting Data Field Values\fR
.IX Subsection "Converting Data Field Values"
.PP
When converting \fBbpipe\fR data packet field data to \s-1FITS\s0 binary table
data, \fBbp2fits\fR follows this rule set:
.IP "\fBchar\fR \fICharacter \fR \s-1ASCII\s0 text." 4
.IX Item "char Character ASCII text."
.PD 0
.IP "\fBdouble\fR \fIDouble Precision Floating Point\fR" 4
.IX Item "double Double Precision Floating Point"
.PD
64\-bit double precision.
.IP "\fBint\fR \fI32\-Bit Integer\fR" 4
.IX Item "int 32-Bit Integer"
32\-bit double precision.
.IP "\fBuint\fR \fI32\-Bit Integer\fR" 4
.IX Item "uint 32-Bit Integer"
Note that this is converted to a signed 32\-bit integer.  If the
\&\fBverbose\fR flag is set, \fBbp2fits\fR will warn the user.
.IP "\fBDVector2\fR \fIDouble Precision Floating Point\fR" 4
.IX Item "DVector2 Double Precision Floating Point"
An array of double precision floating points will be used.  The array
indexing will be such that x,y pairs from the \fBbpipe\fR will be adjacent
in the binary table and adjacent pairs in the \fBbpipe\fR will be off set by
2 in the binary table.
.IP "\fBDVector3\fR \fIDouble Precision Floating Point\fR" 4
.IX Item "DVector3 Double Precision Floating Point"
An array of double precision floating points will be used.  The array
indexing will be such that x,y,z triplets from the \fBbpipe\fR will be adjacent
in the binary table and adjacent vectors in the \fBbpipe\fR will be off set by
3 in the binary table.
.IP "\fBIVector2\fR \fI32\-Bit Integer\fR" 4
.IX Item "IVector2 32-Bit Integer"
An array of integers will be used.  The array
indexing will be such that x,y pairs from the \fBbpipe\fR will be adjacent
in the binary table and adjacent pairs in the \fBbpipe\fR will be off set by
2 in the binary table.
.IP "\fBIVector3\fR \fI32\-Bit Integer\fR" 4
.IX Item "IVector3 32-Bit Integer"
An array of integers will be used.  The array indexing will be such
that x,y,z triplets from the \fBbpipe\fR will be adjacent in the binary
table and adjacent vectors in the \fBbpipe\fR will be off set by 3 in the
binary table.
.IP "\fBUIVector2\fR \fI32\-Bit Integer\fR" 4
.IX Item "UIVector2 32-Bit Integer"
An array of integers will be used.  The array
indexing will be such that x,y pairs from the \fBbpipe\fR will be adjacent
in the binary table and adjacent pairs in the \fBbpipe\fR will be off set by
2 in the binary table.
.IP "\fBUIVector3\fR \fI32\-Bit Integer\fR" 4
.IX Item "UIVector3 32-Bit Integer"
An array of integers will be used.  The array
indexing will be such that x,y,z triplets from the \fBbpipe\fR will be adjacent
in the binary table and adjacent vectors in the \fBbpipe\fR will be off set by
3 in the binary table.
.IP "\fBDComplex\fR \fIDouble Precision Complex\fR" 4
.IX Item "DComplex Double Precision Complex"
An array of double precision floating points will be used.  The array
indexing will be such that r,i pairs from the \fBbpipe\fR will be adjacent
in the binary table and adjacent pairs in the \fBbpipe\fR will be off set by
2 in the binary table.
.IP "\fBDCVector2\fR \fIDouble Precision Complex\fR" 4
.IX Item "DCVector2 Double Precision Complex"
An array of double precision complex will be used.  The array
indexing will be such that c1,c2 pairs from the \fBbpipe\fR will be adjacent
in the binary table and adjacent pairs in the \fBbpipe\fR will be off set by
2 in the binary table.
.IP "\fBDCVector3\fR \fIDouble Precision Complex\fR" 4
.IX Item "DCVector3 Double Precision Complex"
An array of double precision complex will be used.  The array
indexing will be such that c1,c2,c3 triplets from the \fBbpipe\fR will be
adjacent in the binary table and adjacent vectors in the \fBbpipe\fR will be
off set by 3 in the binary table.
.SS "Automatically Generated Keywords"
.IX Subsection "Automatically Generated Keywords"
\&\fBbp2fits\fR will attempt to generate appropriate values for various
column specific keywords.  The user may override these using the
\&\fBtrans\fR file.
.PP
The following keywords are always generated:
\&\f(CW\*(C`TUNIT\*(C'\fR,
\&\f(CW\*(C`TNULL\*(C'\fR,
\&\f(CW\*(C`TSCAL\*(C'\fR,
\&\f(CW\*(C`TZERO\*(C'\fR,
\&\f(CW\*(C`TDISP\*(C'\fR,
\&\f(CW\*(C`TDIM\*(C'\fR.
.PP
The following are generated if  \fBreserved\fR is set to yes.
.IP "\s-1TLMIN\s0" 4
.IX Item "TLMIN"
This keyword is set to the value for \s-1TDMIN\s0 if not present in the
\&\fBtrans\fR file or if no \fBtrans\fR file is specified and the
\&\fBdoublepass\fR flag is set.  It is left out of the \s-1HDU\s0 if \s-1TDMIN\s0 is not
present in the \s-1HDU.\s0
.IP "\s-1TDMIN\s0" 4
.IX Item "TDMIN"
This keyword is calculated from the data if not present in the
\&\fBtrans\fR file or if no \fBtrans\fR file is specified and the
\&\fBdoublepass\fR flag is set.  It is left out of the \s-1HDU\s0 otherwise.
.IP "\s-1TDMAX\s0" 4
.IX Item "TDMAX"
This keyword is calculated from the data if not present in the
\&\fBtrans\fR file or if no \fBtrans\fR file is specified and the
\&\fBdoublepass\fR flag is set.  It is left out of the \s-1HDU\s0 otherwise.
.IP "\s-1TLMAX\s0" 4
.IX Item "TLMAX"
This keyword is set to the value for \s-1TDMAX\s0 if not present in the
\&\fBtrans\fR file or if no \fBtrans\fR file is specified and the
\&\fBdoublepass\fR flag is set.  It is left out of the \s-1HDU\s0 if \s-1TDMIN\s0 is not
present in the \s-1HDU.\s0
.SS "Trans File"
.IX Subsection "Trans File"
The \fBtrans\fR option specifies an \s-1RDB\s0 formatted file that guides the
translation of the input \fBbpipe\fR file to the output \s-1FITS\s0 file.  The
\&\fBtrans\fR file is required to have at least two columns, \fIbpipefield\fR
and \fIfitsfield\fR.  These columns provide a mapping between the input
\&\fBbpipe\fR dpktf names and the output \s-1FITS\s0 binary table column names, see
\&\*(L"Required Columns\*(R".
.PP
In addition, the \fBtrans\fR file may contain \s-1RDB\s0 header variables which
are converted to \s-1FITS\s0 header keywords, see \*(L"Optional Header
Variables\*(R", and additional special columns described below,
\&\*(L"Optional Columns\*(R".
.PP
\fIOptional Header Variables\fR
.IX Subsection "Optional Header Variables"
.PP
If the user wishes to add \s-1FITS\s0 header keywords to either the primary
\&\s-1HDU\s0 or the \s-1HDU\s0 of the binary table in the output \s-1FITS\s0 file, it is
possible to do so via the optional \s-1RDB\s0 header variables in the
\&\fBtrans\fR file.
.PP
As described in \*(L"\s-1CONVERTING BPIPE TO FITS\*(R"\s0, \fBbp2fits\fR handles
converting \fBbpipe\fR header fields to \s-1FITS\s0 header keywords.  By
specifying \s-1RDB\s0 header variables in the \fBtrans\fR file, the user may add
\&\s-1FITS\s0 keywords to the output.  By default, \fBbp2fits\fR places \s-1RDB\s0 header
variables in the \s-1HDU\s0 associated with the \s-1FITS\s0 binary table.  It is
also possible to force the header variables in the \s-1FITS\s0 file's primary
\&\s-1HDU.\s0  This is done by prepending the modifier \fI\s-1PRIMARY::\s0\fR to the \s-1RDB\s0
header variable name.
.PP
.Vb 4
\&    ...snip...
\&    #: PRIMARY::IWRITETO=Primary Header Data Unit
\&    #: IWRITETO=The binary tables HDU...
\&    ...snip...
.Ve
.PP
Certain \s-1FITS\s0 header keywords call for special values, such as the date
the file was created, or the name of the user who created the file.
To enable the user to handle these cases, \fBbp2fits\fR provides the user
with special header field values denoted by a leading \fI%\fR character.
.PP
Special Header Field Values
.IX Subsection "Special Header Field Values"
.PP
\&\fBbp2fits\fR defines three special header field values which may be
specified in the \fBtrans\fR file.
.IP "\fB\f(CB%user\fB\fR" 4
.IX Item "%user"
If a header variable in the \fBtrans\fR file is set to \fB\f(CB%user\fB\fR,
\&\fBbp2fits\fR attempts to determine the current user name via first
getlogin or, failing that, getpwuid.
.IP "\fB\f(CB%date\fB\fR" 4
.IX Item "%date"
If a header variable in the \fBtrans\fR file is set to \fB\f(CB%date\fB\fR,
\&\fBbp2fits\fR attempts to determine the current date via the localtime
function.  The date is output in day/month/year format.
.IP "\fB\f(CB%time\fB\fR" 4
.IX Item "%time"
If a header variable in the \fBtrans\fR file is set to \fB\f(CB%time\fB\fR,
\&\fBbp2fits\fR attempts to determine the current time via the localtime
function.  The time is output in hour:minute:seconds format.
.PP
\fIRequired Columns\fR
.IX Subsection "Required Columns"
.PP
The \fBtrans\fR file must contain at least two columns, \fIbpipefield\fR and
\&\fIfitsfield\fR.  The \fIbpipefield\fR and \fIfitsfield\fR columns allow the
user to explicitly map the \fBbpipe\fR dpktf name to a valid \s-1FITS\s0 binary
table name.  If a \fBbpipe\fR dpktf name is not listed in the \fBtrans\fR file
\&\fIbpipefield\fR column, it is treated in the default manner by
\&\fBbp2fits\fR, see \*(L"\s-1CONVERTING BPIPE TO FITS\*(R"\s0  \*(L"Data Fields\*(R".
.IP "bpipefield" 4
.IX Item "bpipefield"
Dpktf name in \fBbpipe\fR, exact match required.
.IP "fitsfield" 4
.IX Item "fitsfield"
\&\s-1FITS\s0 binary table column name.  Must be an allowable \s-1FITS\s0 value,
i.e. less than 70 characters, comprised of letters, digits, and the
underscore character \fI_\fR.
.Sp
\&\fBbpipe\fR vector fields are mapped to multiple \s-1FITS\s0 binary table columns.
The user my specify the column names as follows:
.RS 4
.IP "\(bu" 4
A common prefix, to which the default suffixes (which depend upon the
actual \fBbpipe\fR data type) are appended, e.g. \f(CW\*(C`position_\*(C'\fR which in
the case of a \fBDVector3\fR would yield \f(CW\*(C`position_x\*(C'\fR, \f(CW\*(C`position_y\*(C'\fR,
and \f(CW\*(C`position_z\*(C'\fR.
.IP "\(bu" 4
A common prefix and user supplied suffixes, e.g. \f(CW\*(C`position,_x,YYY,Zeh\*(C'\fR
which would yield \f(CW\*(C`position_x\*(C'\fR, \f(CW\*(C`positionYYY\*(C'\fR, and \f(CW\*(C`positionZEh\*(C'\fR.
.IP "\(bu" 4
The special character \f(CW\*(C`!\*(C'\fR and user supplied suffixes, e.g. \f(CW\*(C`!,_x,YYY,Zeh\*(C'\fR
which would yield \f(CW\*(C`_x\*(C'\fR, \f(CW\*(C`YYY\*(C'\fR, and \f(CW\*(C`ZEh\*(C'\fR.
.RE
.RS 4
.RE
.PP
\fIOptional Columns\fR
.IX Subsection "Optional Columns"
.PP
There are certain optional \s-1FITS\s0 keywords that are useful to add to the
output header, e.g. \s-1TUNIT, TNULL, TSCALE,\s0 etc.  In many cases, it is
difficult to determine appropriate values from the input \fBbpipe\fR.
\&\fBbp2fits\fR allows the user to supply values for various \s-1FITS\s0 reserved
keywords via the \fBtrans\fR translation file.
.PP
The \fBtrans\fR file may contain any of the following, optional, columns
as well: units, null, scale, zero, disp, dim, lmin, dmin, dmax, or
lmax.  These columns correspond to the indexed \s-1FITS\s0 keywords of the
same name, e.g. lmin == TLMINxxx where xxx is the index of the column
\&\s-1TLMIN\s0 refers.  If a \fBbpipe\fR data packet fields's optional translation
columns are not specified, it is treated in the default manner by
\&\fBbp2fits\fR, see \*(L"\s-1CONVERTING BPIPE TO FITS\*(R"\s0 \*(L"Data Fields\*(R".
.PP
A listing of the optional columns is provided below:
.IP "units" 4
.IX Item "units"
The physical units for the corresponding field.
.IP "null" 4
.IX Item "null"
The integer that represents an undefined value for fields of type
B(unsigned 8\-bit integer), I(16\-bit integer), or J(32\-bit integer).
.IP "scale" 4
.IX Item "scale"
The scale factor for the corresponding field to scale it to a physical
quantity, whose possible units are specified via the \fBunits\fR column.
Used along with \fBzero\fR.  \fBscale\fR is ignore for fields of type
A(Character), L(Logical), or X(Bit Array).
.IP "zero" 4
.IX Item "zero"
Used along with \fBscale\fR, it is the zero point for the physical
representation of the field value.  \fBzero\fR is ignore for fields of
type A(Character), L(Logical), or X(Bit Array).
.IP "disp" 4
.IX Item "disp"
Character string describing the format recommended for displaying the
data in the corresponding field.
.IP "lmin" 4
.IX Item "lmin"
The legal lower limit for data in this field.
.IP "dmin optional" 4
.IX Item "dmin optional"
The actual minimum value for the data in this field.
.IP "dmax optional" 4
.IX Item "dmax optional"
The actual maximum value for the data in this field.
.IP "lmax" 4
.IX Item "lmax"
The legal upper limit for data in this field.
.SH "VERSION"
.IX Header "VERSION"
This documents version 1.2.6 of \fBbp2fits\fR.
.SH "COPYRIGHT AND LICENSE"
.IX Header "COPYRIGHT AND LICENSE"
Copyright 2006 Smithsonian Astrophysical Observatory
.PP
This software is released under the \s-1GNU\s0 General Public License. You may
find a copy at
.PP
.Vb 1
\&     http://www.fsf.org/copyleft/gpl.html
.Ve
.SH "AUTHORS"
.IX Header "AUTHORS"
Diab Jerius <djerius@cfa.harvard.edu>
.PP
Michael Tibbetts <mtibbetts@cfa.harvard.edu>
