#Right before uninstalling
if [ -f ${PREFIX}/param/.param.ciao-contrib ] ; then
  #If the parameter file manifest exists, 
  # remove the write permissions on those files
  cat ${PREFIX}/param/.param.ciao-contrib |
  while read FILE dummy ; do
    chmod -R a+w $PREFIX/param/${FILE}
  done
  chmod a+w $PREFIX/config/ciao.ds9
fi

#Temporarily move ciao-contrib xml files before
# re-indexing the ahelp files
if [ -f ${PREFIX}/share/doc/xml/.xml.ciao-contrib ] ; then
  if [ "x$ASCDS_INSTALL" != "x" ] && [ "x${SKIP_AHELP_INDEXING}" != "xy" ] ; then
    which ahelp
    if [ "$?" = "0" ] ; then
      mkdir -p ${PREFIX}/share/doc/xml/ciao-contrib
      #If the xml file manifest exists,
      # move those files and re-index ahelp
      cat ${PREFIX}/share/doc/xml/.xml.ciao-contrib |
      while read FILE dummy ; do
        mv $PREFIX/share/doc/xml/${FILE}  ${PREFIX}/share/doc/xml/ciao-contrib/${FILE}
      done
      # re-index ahelp
      ahelp -r
      # move the ahelp files back
      cat ${PREFIX}/share/doc/xml/.xml.ciao-contrib |
      while read FILE dummy ; do
        mv $PREFIX/share/doc/xml/ciao-contrib/${FILE}  ${PREFIX}/share/doc/xml/${FILE}
      done
      rm -r ${PREFIX}/share/doc/xml/ciao-contrib
    else
      echo "ahelp was not available while attempting to re-index. Please run: $> ahelp -r" >> $PREFIX/.messages.txt
    fi
  else
    echo "CIAO was not active while attempting to re-index. Please run: $> ahelp -r" >> $PREFIX/.messages.txt
  fi
fi
