if ( ! $?IPYTHONDIR ) then
   #Default
   setenv IPYTHONDIR $HOME/.ipython-ciao
endif

setenv ASCDS_INSTALL $CONDA_PREFIX
setenv OBSVIS_PKG_PATH $ASCDS_INSTALL/lib/tcltk/packages/obsvis
setenv ASCDS_CALIB $ASCDS_INSTALL/data

#  The path of the working directory of the user
if ( ! $?ASCDS_WORK_PATH ) then
   if ( $?TMPDIR ) then
      if ( -d $TMPDIR ) then
         setenv ASCDS_WORK_PATH $TMPDIR
      else
         echo "WARNING: TMPDIR is set to '${TMPDIR}' but is not a directory, setting ASCDS_WORK_PATH to /tmp instead"
         setenv ASCDS_WORK_PATH /tmp
      endif
   else
      setenv ASCDS_WORK_PATH /tmp
   endif
endif
if ( ! $?ASCDS_TMP ) then
   if ( $?TMPDIR ) then
      if ( -d $TMPDIR ) then
         setenv ASCDS_TMP $TMPDIR
      else
         echo "WARNING: TMPDIR is set to '${TMPDIR}' but is not a directory, setting ASCDS_TMP to /tmp instead"
         setenv ASCDS_TMP /tmp
      endif
   else
      setenv ASCDS_TMP /tmp
   endif
endif

#Set XPA_METHOD to local to avoid issues if not network connection
setenv XPA_METHOD local

#Default sys param for the install
setenv ASCDS_SYS_PARAM $ASCDS_INSTALL/param

if ( ! $?LOCPFILES ) then
   #Defaults to $HOME/cxcds_param4
   setenv LOCPFILES "$HOME/cxcds_param4"
endif

if ($?PFILES) then
   #  use the PFILES local dir value for the PDIRS local dir value
   set SYSPF = (`echo $PFILES | sed "s%.*;%%"`)
   set LOCPF = (`echo $PFILES | sed "s%;.*%%"`)
else
   set LOCPF = ""
   set SYSPF = ""
endif

if ( `echo $LOCPF | grep $LOCPFILES` != "" ) then
   set LOCPF = (`echo " $LOCPF " | sed "s%$LOCPFILES%%g"`)
endif
if ( $LOCPF != "" ) then
   set LOCPF = ${LOCPFILES}:${LOCPF}
else
   set LOCPF = ${LOCPFILES}
endif

if ( `echo $SYSPF | grep "$ASCDS_SYS_PARAM"` != "" ) then
   set SYSPF = (`echo " $SYSPF " | sed "s%$ASCDS_SYS_PARAM%%g"`)
endif

if ( $SYSPF != "" ) then
   set SYSPF = ${ASCDS_SYS_PARAM}:${SYSPF}
else
   set SYSPF = ${ASCDS_SYS_PARAM}
endif

setenv PFILES "$LOCPF;$SYSPF"
setenv PFILES `echo "{$PFILES}" | sed "s%::%:%g"`

set _tmp=`echo "$LOCPFILES" | sed "s%:% %g"`
foreach _dir (`echo "$_tmp"`)
   if ( ! -d "$_dir" ) then
      mkdir $_dir     # if local param dir does not exist, create it
   endif
end

#Set ASCDS_* environment variables
setenv ASCDS_BIN $ASCDS_INSTALL/bin
setenv ASCDS_LIB $ASCDS_INSTALL/lib
setenv ASCDS_OTS $ASCDS_INSTALL
setenv ASCDS_PROP_DATE_DATA $ASCDS_INSTALL/config/jcm_data
setenv ASCDS_PROP_PREC_DATA $ASCDS_INSTALL/config/jcm_data


unset _tmp LOCPF SYSPF _dir
