############################################################################
# 
#  Copyright (C) 2008-2009,2011  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: ciao.csh
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the environment for OBSVIS
#
#       This version of the script is written in the csh language, and
#       is compatible tcsh, too.
#
############################################################################

if ( ! $?ASCDS_CIAO ) then

################################################################
#               Setup for ASCDS Installation root              #
################################################################

   set _nextASCDS_INSTALL = /opt/conda/envs/ciao-4.17.0 

################################################################
#                set obsvis environment variables                #
################################################################

   if (-x /opt/conda/envs/ciao-4.17.0/imager/ds9 ) then
      if ( ! $?ASCDS_IMAGER_PATH ) then
	 setenv ASCDS_IMAGER_PATH /opt/conda/envs/ciao-4.17.0/imager
      endif
   endif
   setenv OBSVIS_PKG_PATH $_nextASCDS_INSTALL/lib/tcltk/packages/obsvis

################################################################
#                         Adjust paths                         # 
################################################################

#  The path of the working directory of the user
    if ( ! $?ASCDS_WORK_PATH ) then
	setenv ASCDS_WORK_PATH /tmp
    endif

#  Add ASCDS_BIN to path- if it exists move to it the front
   if ( `echo $path | grep $_nextASCDS_INSTALL/bin` != "" ) then
      set path = (`echo " $path " | sed "s% $_nextASCDS_INSTALL/bin % %g"`)
   endif

   if ( ${?path} ) then
      set path = ( $_nextASCDS_INSTALL/bin $path )
   else
      set path = ( $_nextASCDS_INSTALL/bin )
   endif

   setenv ASCDS_INSTALL "$_nextASCDS_INSTALL"
    
   unset _nextASCDS_INSTALL
else
   setenv OBSVIS_PKG_PATH $ASCDS_INSTALL/lib/tcltk/packages/obsvis
endif
