""" 
test the import order of loading libraries which are all dependent to libcaldb4
"""
import unittest
import sys,os


def whoami():
    return sys._getframe(1).f_code.co_filename+'.'+sys._getframe(1).f_code.co_name


DEBUG=0
class TestImports(unittest.TestCase):
    def setUp(self):
        global DEBUG
        if "-v" in  sys.argv:
            DEBUG=1

   
#=============================================================================
#
#   --- The Tester ---
#
#=============================================================================
   
#======================================================
# test_failOrder* - test the abnormal procedure on OS X
#=======================================================
    def _test_000_okOrder1(self):
        try:
            t1 = __import__("pixlib")
            t2 = __import__("caldb4")
            print ("Okay to 'import pixlib,caldb4'"  )
        except ImportError as e:
            raise ImportError("fail to 'import pixlib,caldb4'\n%s" % e)
       

    def _test_000_okOrder2(self):
        try:
            t1 = __import__("pixlib")
            t4 = __import__("paramio")
            t2 = __import__("caldb4")
            print ("Okay to 'import pixlib,paramio,caldb4'"  )
        except ImportError as e:
            raise ImportError("fail to 'import pixlib,paramio,caldb4'\n%s" % e)
                        

    def test_failOrder1(self):
        try:
            t2 = __import__("caldb4")
            t1 = __import__("pixlib")
            print ("Okay to 'import caldb4,pixlib'"  )
        except ImportError as e:
            raise ImportError("fail to 'import caldb4,pixlib'\n%s" % e)
              

    def test_failOrder2(self):
        try:
            t2 = __import__("caldb4")
           # t3 = __import__("psf")
            print ("Okay to 'import caldb4,psf'"  )
        except ImportError as e:
            raise ImportError("fail to 'import caldb4,psf'\n%s" % e)
  

    def test_failOrder3(self):
        try:
            t1 = __import__("pixlib")
           # t3 = __import__("psf")
            print ("Okay to 'import pixlib,psf'"  )
        except ImportError as e:
            raise ImportError("fail to 'import pixlib,psf'\n%s" % e)
 
    def test_failOrder4(self):
        try:
            t2 = __import__("caldb4")
            t1 = __import__("pixlib")
           # t3 = __import__("psf")
            print ("Okay to 'import caldb4,pixlib,psf'"  )
        except ImportError as e:
            raise ImportError("fail to 'import caldb4,pixlib,psf'\n%s" % e)
   
    def test_failOrder5(self):
        try:
          #  t3 = __import__("psf")
            t2 = __import__("caldb4")
            print ("Okay to 'import psf,caldb4'" )
        except ImportError as e:
            raise ImportError("fail to 'import psf,caldb4'\n%s" % e)

 
          
if __name__ == "__main__":
    unittest.main(defaultTest="TestImports")
