from abc import ABCMeta, abstractmethod

from .configuration import Configuration
from .io import InputOutputFactory
from .logger import logger, set_up_logger


class Tool(metaclass=ABCMeta):
    configuration_class = None

    def __init__(self, name, configuration_factory, io_factory: InputOutputFactory):
        self.name = name
        self.configuration_factory = configuration_factory
        self.io_factory = io_factory

    def run(self, **parameters):
        setup_logger = parameters.pop('setup_logger', False)
        try:
            configuration = self.configuration_factory.create(self, **parameters)
            if setup_logger:
                if 'verbose' in configuration:
                    set_up_logger(configuration.verbose, self.name)
                else:
                    set_up_logger(0, self.name)
            return self._run(configuration)
        except:  # too broad, but this is a strong requirement in the pipeline
            logger.critical("Critical Error")
            logger.exception("Source of the error:")

    @abstractmethod
    def _run(self, configuration: Configuration):
        raise NotImplementedError()
