import argparse

from .serial_executor import SerialExecutor
from .print_results import print_results
from .process_results import process_results
from .find_files import find_files_with_glob
from .extract_keywords import extract_fits_keywords
from .progress_bar import simple_progress_bar


def main():
    parser = argparse.ArgumentParser(description="Extract the DS_IDENT keyword from FITS files.")
    parser.add_argument('directory', type=str, help='Directory to search for FITS files.')
    parser.add_argument('--include', nargs='+', default=['**/*.fits', '**/*.fits.gz'],
                        help='Include patterns for FITS files.')
    parser.add_argument('--exclude', nargs='+', default=[], help='Exclude patterns for FITS files.')

    args = parser.parse_args()

    file_paths = find_files_with_glob(args.directory, args.include, args.exclude)
    with SerialExecutor(len(file_paths), simple_progress_bar) as executor:
        results = extract_fits_keywords(file_paths, ['DS_IDENT'], executor)

    processed_results = process_results(results)

    print_results(processed_results)


if __name__ == "__main__":
    main()
