import pytest
from unittest.mock import patch
from ..find_files import find_files_with_glob  # Import the function from your actual module file


@pytest.fixture
def setup_filesystem():
    return [
        "/path/to/data/file1.fits",
        "/path/to/data/nested/file2.fits.gz",
        "/path/to/data/draft_file1.fits",
        "/path/to/data/test_file2.fits.gz"
    ]


def test_default_include_exclude(setup_filesystem):
    with patch('glob.glob') as mock_glob:
        mock_glob.return_value = setup_filesystem
        files = find_files_with_glob("/path/to/data")
        assert "/path/to/data/file1.fits" in files
        assert "/path/to/data/nested/file2.fits.gz" in files
        assert "/path/to/data/draft_file1.fits" in files
        assert "/path/to/data/test_file2.fits.gz" in files


def test_include_specific_files(setup_filesystem):
    with patch('glob.glob') as mock_glob:
        mock_glob.return_value = setup_filesystem
        files = find_files_with_glob("/path/to/data", include_patterns=['**/*.fits'])
        assert "/path/to/data/file1.fits" in files
        assert "/path/to/data/file2.fits.gz" not in files


def test_exclude_specific_files(setup_filesystem):
    with patch('glob.glob') as mock_glob:
        mock_glob.return_value = setup_filesystem
        files = find_files_with_glob("/path/to/data", exclude_patterns=['*draft*'])
        assert "/path/to/data/draft_file1.fits" not in files
        assert "/path/to/data/file1.fits" in files


def test_complex_patterns(setup_filesystem):
    with patch('glob.glob') as mock_glob:
        mock_glob.return_value = setup_filesystem
        files = find_files_with_glob("/path/to/data", include_patterns=['**/*.fits.gz'], exclude_patterns=['*test*'])
        assert "/path/to/data/nested/file2.fits.gz" in files
        assert "/path/to/data/test_file2.fits.gz" not in files
