#!/opt/conda/envs/ciao-4.17.0/bin/python3
# 
#  Copyright (C) 2006-2007,2016  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

from __future__ import print_function

from pytransform import *
from numpy import array
import numpy
from os import environ


#  Setup input/output directories
#
testin  = environ.get('TESTIN')
if testin == None :
  indir = environ.get('PWD')
else :
  indir = testin + '/test_transform'

testout = environ.get('TESTOUT')
if testout == None :
  outdir = environ.get('PWD')
else :
  outdir = testout + '/transform'

print("\n************************************************************")
print("                      LINEARTransform                       ")
print("************************************************************")
#
# Wrapped and running
#   LINEARTransform();
#   LINEARTransform(string in_name);
#   LINEARTransform(string in_name, list<TransParam*> in_params);
#   LINEARTransform(string in_name, LINEARTransform&);
#
#   string get_name();
#   void   set_name(string in_name);
#
#   void set_parameter_list(list<TransParam*> in_params);
#   list<TransParam*> get_parameter_list();
#   void print_parameter_list();
#
#   trErrCode  set_parameter(TransParam* in_param);
#   TransParam* get_parameter(string in_name);
#   void*      get_parameter_value(string in_name);
#
#   void* apply(void* in_array, dmDataType in_datatype);
#   void* invert(void* in_array, dmDataType in_datatype);
# ----------------------------------------------------------------------
print("\nCreate LINEAR Transform object")
T1 = LINEARTransform()
print("  T1 = LINEARTransform()... OK")

print("\nDisplay Default Parameter Info")
print("  T1.print_parameter_list()...")
print(T1.print_parameter_list())

# ----------------------------------------------------------------------
print("\nCreate LINEAR Transform object with name.")
T2 = LINEARTransform("T2")
print("  T2 = LINEARTransform('T2')... OK")

print("\nDisplay Default Parameter Info")
print("  T2.print_parameter_list()...")
print(T2.print_parameter_list())

# ----------------------------------------------------------------------
print("\nName handling")

name = T2.get_name()
print("  T2.get_name()            => ", name)

T1.set_name("T1")
print("  T1.set_name('T1')")
print("  T1.get_name()            => ", T1.get_name())

# ----------------------------------------------------------------------

print("\nDisplay Parameter Info")
print("  T1.print_parameter_list()...")
print(T1.print_parameter_list())

print("\n  T2.print_parameter_list()...")
print(T2.print_parameter_list())


# ----------------------------------------------------------------------


print("\nUpdate Parameters in T1 LINEARTransform")
tpar = T1.get_parameter("SCALE")
tpar.set_value(1800.000)

tpar = T1.get_parameter("OFFSET")
tpar.set_value(1326189100.000)

print("\nDisplay T1 Parameter Info")
print(T1.print_parameter_list())


# ----------------------------------------------------------------------

print("\n- Set input data 1D array")

darr = array([   0.5,    1.5,    2.5,    3.5,    4.5,    5.5,    6.5,    7.5,    8.5,    9.5,
                 10.5,   11.5,   12.5,   13.5,   14.5,   15.5,   16.5,   17.5,   18.5,   19.5,
                 20.5,   21.5,   22.5,   23.5,   24.5,   25.5,   26.5,   27.5,   28.5,   29.5,
                 30.5,   31.5,   32.5,   33.5,   34.5,   35.5,   36.5,   37.5,   38.5,   39.5,
                 40.5,   41.5,   42.5,   43.5,   44.5,   45.5,   46.5,   47.5,   48.5,   49.5,
                 50.5,   51.5 ,  52.5,   53.5,   54.5,   55.5,   56.5,   57.5,   58.5,   59.5,
                 60.5,   61.5,   62.5,   63.5,   64.5,   65.5,   66.5,   67.5,   68.5,   69.5,
                 70.5,   71.5,   72.5,   73.5,   74.5,   75.5,   76.5,   77.5,   78.5,   79.5,
                 80.5,   81.5,   82.5,   83.5,   84.5,   85.5,   86.5,   87.5,   88.5,   89.5,
                 90.5,   91.5 ,  92.5,   93.5,   94.5,   95.5,   96.5,   97.5,   98.5,   99.5,
                 100.5,  101.5,  102.5,  103.5,  104.5,  105.5,  106.5,  107.5,  108.5,  109.5,
                 110.5,  111.5,  112.5,  113.5,  114.5,  115.5,  116.5,  117.5,  118.5,  119.5,
                 120.5,  121.5,  122.5,  123.5,  124.5,  125.5,  126.5,  127.5,  128.5,  129.5,
                 130.5,  131.5,  132.5,  133.5,  134.5,  135.5,  136.5,  137.5,  138.5,  139.5,
                 140.5,  141.5,  142.5], dtype=numpy.double)


print(darr)

print("\n- Apply Transform")
trans_vals = T1.apply(darr)
print(trans_vals)

print("\n- Invert Transform")
inv_vals = T1.invert(trans_vals)
print(inv_vals)

if darr.all() == inv_vals.all():
  print("\nOriginal array and inverse transformed array are equal!")

# ----------------------------------------------------------------------

print("\nDone.\n")
