# 
#  Copyright (C) 2007-2010,2012,2014  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#


lappend auto_path . $env(OBSVIS_PKG_PATH)



package require Tktable
package require OBSVIS $env(OBSVIS_VERSION)


global ds9
set Ds9RequiredVersion $env(DS9_REQUIRED_VERSION)


if { $ds9(version) < $Ds9RequiredVersion } {
    tk_messageBox -icon error -type ok -title "OBSVIS Error" -message "I found ds9 version '$ds9(version)' in your path. OBSVIS requires ds9 version $Ds9RequiredVersion or higher. Please modify your PATH environment variable  or start obsvis using '-imager full_imager_path' option"
    QuitDS9
}

OBSVISGui::New $env(OBSVIS_MODE)

# starting at 7.3 ds9 defaults to not being in region mode. However this 
# is not natural to obsvis environment. Update to region mode after everything
# has loaded
if { $ds9(version) >= 7.3 } {
  after idle [ds9Cmd "-mode region"]
}



