.\" Automatically generated by Pod::Man 4.10 (Pod::Simple 3.35)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "fits2rdb l"
.TH fits2rdb l "2017-08-01" " " " "
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
fits2rdb \- Converts FITS binary table to RDB table
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBfits2rdb\fR
.PP
.Vb 1
\&  [ \-i | \-\-input the_input_FITS_filename ] 
\&
\&  [ \-o | \-\-output the_output_RDB_filename ] 
\&
\&  [ \-e | \-\-extname the_FITS_extension_name ] 
\&
\&  [ \-n | \-\-extnum the_FITS_extension_number ]
\&
\&  [ \-m | \-\-comment ]
\&
\&  [ \-c | \-\-column column_name_to_include_in_output ]
\&
\&  [ \-r | \-\-rcolumn regex_for_included_FITS_column_names ]
\&
\&  [ \-C | \-\-vcolumn column_name_to_exclude_from_output ]
\&
\&  [ \-R | \-\-rvcolumn regex_for_excluded_FITS_column_names ]
\&
\&  [ \-d | \-\-defformat FITS_type=printf_style_format ]
\&
\&  [ \-f | \-\-colformat column_name=printf_style_format ]
\&
\&  [ \-a | \-\-arraysep array_element_seperator ]
\&
\&  [ \-t | \-\-trim yes|no ]
\&
\&  [ \-T | \-\-truevalue string_representation_of_true ]
\&
\&  [ \-F | \-\-falsevalue string_representation_of_false ]
\&
\&  [ \-I | \-\-invalidvalue string_representation_of_invalid ]
\&
\&  [ \-B | \-\-byte str|num ]
\&
\&  [ \-x | \-\-maxrows rows_per_read ]
\&
\&  [ \-h | \-\-help ]
\& 
\&  [ \-u | \-\-usage ]
\&
\&  [ \-v | \-\-version ]
\&
\&  [ \-V | \-\-verbose ]
\&
\&  [ the_input_FITS_filename ]
\&
\&  [ the_output_FITS_filename ]
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBfits2rdb\fR converts a \s-1FITS\s0 binary table extension to an \s-1RDB\s0 table.
Default behavior is to convert the entire table.  The user may specify
that only certain columns be converted and output using the
\&\fB\-\-column\fR, \fB\-\-rcolumn\fR, \fB\-\-vcolumn\fR, and \fB\-\-rvcolumn\fR options.
Column specifications are case insensitive; Output column names are
all lowercase.  For \fB\-\-rcolumn\fR and \fB\-\-rvcolumn\fR, the regular
expressions are Perl5 regular expressions. See the pcre manpage for a
description of the few exceptions.
.PP
The user may also specify that the \s-1FITS\s0 header data unit(\s-1HDU\s0) be converted into \s-1RDB\s0 comments using the \fB\-\-comment\fR option.
.PP
The input \s-1FITS\s0 file is specified via the \fB\-\-input\fR option.  To
specify a particular \s-1FITS\s0 extension within the file, the user may
provide the extension name and extension number via the \fB\-\-extname\fR
and \fB\-\-extnum\fR options.
.PP
If the user is familiar with the Funtools IRAF-style bracket notation,
it is possible to specify the file, extension, and filters with the
\&\fB\-\-input\fR option.
.PP
It is also possible to specify input and output filenames as
non-option arguments on the commandline.  To do so, simply specify the
input name and, optionally, the output name.
.PP
Here are three commandlines illustrating the various syntax.
.Sp
.RS 4
\&\fBfits2rdb\fR \fB\-\-comment\fR \fB\-\-input\fR=test_input.fits \fB\-\-output\fR=converted_output.rdb
.Sp
\&\fBfits2rdb\fR \fB\-\-comment\fR \fB\-i\fR test_input.fits \fB\-o\fR converted_output.rdb
.Sp
\&\fBfits2rdb\fR \fB\-\-comment\fR test_input.fits converted_output.rdb
.RE
.PP
If no extension name is specified, \fBfits2rdb\fR searches for the first
extension with the name \s-1EVENTS, STDEVT,\s0 or \s-1RAYTRACE.\s0  Failing that, it
reopens the file and searches each extension until it finds a binary
table.  \fBfits2rdb\fR then processes the binary table.
.PP
The conversion is handled as follows:
.Sp
.RS 4
A column with scalar value is output as an \s-1RDB\s0 column with scalar value.
.Sp
A column with non-bit array value is output as an \s-1RDB\s0 column with array elements seperated by \fB\-\-arraysep\fR.
.Sp
A column with bit array value is output as an \s-1RDB\s0 column with each 8 bit byte represented in hexidecimal format and seperated by \fB\-\-arraysep\fR.
.Sp
For bit fields, bits are output in the same order as specified in the \s-1FITS\s0 standard, \s-1MSB\s0 to \s-1LSB.\s0
.RE
.PP
If no column options are specified all columns will be output.  If any column options are specified, only the columns matching the specification will be output.
.PP
If column options are present on the command line, output columns are are determined by building a list of column consisting of the columns specified with the \fB\-\-column\fR and \fB\-\-rcolumn\fR options, less the columns specified with the \fB\-\-vcolumn\fR and \fB\-\-rvcolumn\fR options.
.PP
If the \fB\-\-comment\fR option is specified, \s-1FITS HDU\s0 keywords are output
as \s-1RDB\s0 comment variables.  Keywords are lowercased upon output.  \s-1FITS\s0
\&'\s-1COMMENT\s0' and '\s-1HISTORY\s0' keywords are appended with '_XXX' where \s-1XXX\s0 is
an integer specifying the order of the '\s-1COMMENT\s0' or '\s-1HISTORY\s0' keyword
in the header.  If the \fI\s-1LONGSTRN\s0\fR keyword is present, \fBfits2rdb\fR
will join lines which are continued across multiple \s-1FITS\s0 cards into a
single \s-1RDB\s0 comment.
.SH "OPTIONS"
.IX Header "OPTIONS"
\&\fBfits2rdb\fR uses a \fBgetopt\fR style interface with \s-1POSIX\s0 syntax for
command line options.  Mixing option and non-option arguments is not allowed.
.IP "\fB\-i\fR | \fB\-\-input\fR \fIthe_input_FITS_filename\fR | \fIthe_input_FITS_filename\fR" 4
.IX Item "-i | --input the_input_FITS_filename | the_input_FITS_filename"
Name of the \s-1FITS\s0 file.  If \fB\-\-input\fR equals 'stdin', input is read from \s-1STDIN.\s0  Defaults to stdin.
.IP "\fB\-o\fR | \fB\-\-output\fR \fIthe_output_RDB_filename\fR | \fIthe_output_FITS_filename\fR" 4
.IX Item "-o | --output the_output_RDB_filename | the_output_FITS_filename"
Name of the output \s-1RDB\s0 file.  If \fB\-\-output\fR equals 'stdout', output is written to \s-1STDOUT.\s0  Defaults to stdout.
.IP "\fB\-e\fR | \fB\-\-extname\fR \fIthe_FITS_extension_name\fR" 4
.IX Item "-e | --extname the_FITS_extension_name"
The name of the \s-1FITS\s0 extension upon which to operate.
.IP "\fB\-n\fR | \fB\-\-extnum\fR \fIthe_FITS_extension_number\fR" 4
.IX Item "-n | --extnum the_FITS_extension_number"
The number of the \s-1FITS\s0 extension upon which to operate.
.IP "\fB\-m\fR | \fB\-\-comment\fR" 4
.IX Item "-m | --comment"
If specified, print the \s-1HDU\s0 keywords as \s-1RDB\s0 comment variables.
.IP "\fB\-c\fR | \fB\-\-column\fR \fIcolumn_name_to_include_in_output\fR" 4
.IX Item "-c | --column column_name_to_include_in_output"
Column name to select for output.  \fB\-\-column\fR may be specified
multiple times with different values or may be a comma or whitespace
seperated list.
.IP "\fB\-r\fR | \fB\-\-rcolumn\fR \fIregex_for_included_FITS_column_names\fR" 4
.IX Item "-r | --rcolumn regex_for_included_FITS_column_names"
Regular expression to match against column names in the binary table.
\&\fB\-\-rcolumn\fR may be specified multiple times with different values or
may be comma or whitespace seperated list.  The regular  expression
pattern  matching is done using the same syntax and semantics as Perl
5.  See the pcre man page for more info.
.IP "\fB\-C\fR | \fB\-\-vcolumn\fR \fIcolumn_name_to_exclude_from_output\fR" 4
.IX Item "-C | --vcolumn column_name_to_exclude_from_output"
Excludes the named column from the output table.  \fB\-\-vcolumn\fR may be
specified multiple times with different values or may be a comma or
whitespace seperated list.
.IP "\fB\-R\fR | \fB\-\-rvcolumn\fR \fIregex_for_excluded_FITS_column_names\fR" 4
.IX Item "-R | --rvcolumn regex_for_excluded_FITS_column_names"
Excludes columns that match the regular expression from the output
table.  \fB\-\-rvcolumn\fR may be specified multiple times with different
values or may be a comma or whitespace seperated list.  The regular
expression  pattern  matching is done using the same syntax and
semantics as Perl 5.  See the pcre man page for more info.
.IP "\fB\-d\fR | \fB\-\-defformat\fR \fIFITS_type=printf_style_format\fR" 4
.IX Item "-d | --defformat FITS_type=printf_style_format"
Default output formats.  The user may specify any \s-1FITS\s0 data
type(A,E,I,etc...) and a printf style format string.
.IP "\fB\-f\fR | \fB\-\-colfformat\fR \fIcolumn_name=printf_style_format\fR" 4
.IX Item "-f | --colfformat column_name=printf_style_format"
Column specific output formats.  The user may override the output
formats on a column by column basis by specifying the column name and
a printf style format string.
.IP "\fB\-a\fR | \fB\-\-arraysep\fR \fIarray_element_seperator\fR" 4
.IX Item "-a | --arraysep array_element_seperator"
Seperator used when printing arrays.  Defaults to ','.
.IP "\fB\-t\fR | \fB\-\-trim\fR \fIyes|no\fR" 4
.IX Item "-t | --trim yes|no"
If set to yes(default behavior), trim leading and trail whitespace
from \s-1RDB\s0 comments and table string fields. Otherwise, don't trim
whitespace.
.IP "\fB\-T\fR | \fB\-\-truevalue\fR \fIstring_representation_of_true\fR" 4
.IX Item "-T | --truevalue string_representation_of_true"
Allows the user to set the \s-1RDB\s0 representation of a \s-1FITS\s0 logical field.
.IP "\fB\-F\fR | \fB\-\-falsevalue\fR \fIstring_representation_of_false\fR" 4
.IX Item "-F | --falsevalue string_representation_of_false"
Allows the user to set the \s-1RDB\s0 representation of a \s-1FITS\s0 logical field.
.IP "\fB\-I\fR | \fB\-\-invalidvalue\fR \fIstring_representation_of_invalid\fR" 4
.IX Item "-I | --invalidvalue string_representation_of_invalid"
Allows the user to set the \s-1RDB\s0 representation of a \s-1FITS\s0 logical field.
.IP "\fB\-B\fR | \fB\-\-byte\fR \fIstr|num\fR" 4
.IX Item "-B | --byte str|num"
Represent bytes as string(str) or numbers(num).
.IP "\fB\-x\fR | \fB\-\-maxrows\fR \fIrows_per_read\fR" 4
.IX Item "-x | --maxrows rows_per_read"
Sets the maximum number of rows per read call.  Setting this to a
large number may speed reading of data up to a point.  The default is
8192 rows read at a time.
.IP "\fB\-h\fR | \fB\-\-help\fR" 4
.IX Item "-h | --help"
Print just a list of options and exit.
.IP "\fB\-u\fR | \fB\-\-usage\fR" 4
.IX Item "-u | --usage"
Print this usage info and exit.
.IP "\fB\-v\fR | \fB\-\-version\fR" 4
.IX Item "-v | --version"
Print version info and exit.
.IP "\fB\-V\fR | \fB\-\-verbose\fR" 4
.IX Item "-V | --verbose"
Print warnings about column matches that fail.
.SH "AUTHORS"
.IX Header "AUTHORS"
M. Tibbetts ( mtibbetts@head\-cfa.harvard.edu )
