#include <stdlib.h>
#include <stdio.h>

#include <bpipe/bpipe.h>

/* simple print error and exit routine */
#define error(string)							\
  do {									\
      fprintf( stderr, __FILE__ " %d: %s\n", __LINE__, string );	\
      exit( EXIT_FAILURE );						\
     } while (0)

int
main (int argc, char *argv[])
{
  BPipe *bpipe;
  BPipeOutput *bpo;
  DpktField *dpktf;
  BPMatrix *matrix;
  void *data;
  size_t *dst_off;

  double init = argc > 1 ? atof(argv[1]) : 0.0;


  bpipe_errno = BPNOERROR;

  if ( NULL == ( bpipe = bpipe_new( ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( bpipe_input( bpipe, "stdin" ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( NULL == ( bpo = bpipe_output( bpipe, "stdout" ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  /*
     resize the weight data field, increase the dimension by one. if
     there isn't a weight field, it's an error
   */
  if ( NULL ==
       ( dpktf = bpipe_dpktf( bpipe, "weight" ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( NULL == ( matrix = bpipe_dpktf_matrix( dpktf, BPDSite_CORE, NULL ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  /*
     make a copy of the field's matrix and give it an extra dimension with
     an extent of 2, essentially doubling the size of the matrix.
   */
  matrix->nd++;
  if ( NULL ==
        (matrix->extent = realloc( matrix->extent, matrix->nd * sizeof(size_t) )) )
    error( "couldn't realloc matrix" );
  matrix->extent[matrix->nd - 1] = 2;

  /*
     copy the data to the new matrix by moving everything to the other
     "half" of the doubled matrix
   */
  if ( NULL == (dst_off = bpipe_offset_new( matrix->nd, (size_t) 0 ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  dst_off[matrix->nd - 1] = 1;

  /*
     resize it.  leave most of the details to the routine. the bpipe library
     now has responsibility for the matrix and the offset array.
   */
  if ( bpipe_dpktf_resize_core( dpktf, matrix, NULL, dst_off, NULL) )
    error( bpipe_strerror( bpipe_errno ) );

  /* since there *is* a data packet field, need only check if the return
     sized is 0 and not bpipe_errno as well */
  if ( NULL == ( data = ( bpipe_map_alloc( bpipe, 1, NULL ) ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( bpipe_write_hdr(bpipe) )
    error( bpipe_strerror( bpipe_errno ) );

  /*
     since the weight field is now extended, there will be uninitialized
     elements.  initialize the spot in the core image which holds
     the weight field.
   */

  bpipe_dpktf_init( dpktf, data, &init );

  /* loop through data packets.  not much to do here! */
  while(  bpipe_read_dpkts( bpipe, data, (size_t) 1 )   &&
         !bpipe_write_dpkt( bpipe, data, bpo )    )
    ;

  /*
    bpipe_errno should have been equal to BPNOERROR before the above
    loop
   */
  if ( bpipe_errno != BPNOERROR )
    error( bpipe_strerror( bpipe_errno ) );

  bpipe_delete(bpipe);

  return EXIT_SUCCESS;
}
