#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <bpipe/bpipe.h>

/* simple print error and exit routine */
#define error(string)							\
  do {									\
      fprintf( stderr, __FILE__ " %d: %s\n", __LINE__, string );	\
      exit( EXIT_FAILURE );						\
     } while (0)

int 
main (int argc, char *argv[])
{
  BPipe *bpipe;
  BPipeOutput *bpo;
  DpktField *dpktf;
  BPMatrix *matrix;
  void *data;
  double init = argc > 1 ? atof(argv[1]) : 0.0;
  size_t *dst_off;

  size_t i;

  if ( NULL == ( bpipe = bpipe_new( ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( bpipe_input( bpipe, "stdin" ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( NULL == ( bpo = bpipe_output( bpipe, "stdout" ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  /* resize the weight data field and move the current data, such that
     we create a single element border of new elements along all sides
     of the data */
  if ( NULL == ( dpktf = bpipe_dpktf( bpipe, "weight" ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( NULL == ( matrix = bpipe_dpktf_matrix( dpktf, BPDSite_CORE, NULL ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  /* tweak the matrix */
  for ( i = 0 ; i < matrix->nd ; i++ )
    matrix->extent[i]+=2;

  if ( NULL == ( dst_off = bpipe_offset_new( matrix->nd, (size_t) 1 ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  /* resize it.  leave most of the details to the routine */
  if ( bpipe_dpktf_resize_core( dpktf, matrix, NULL, dst_off, NULL) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( NULL == ( data = bpipe_map_alloc( bpipe, 1, NULL ) ) )
    error( bpipe_strerror( bpipe_errno ) );

  if ( bpipe_write_hdr(bpipe) )
    error( bpipe_strerror( bpipe_errno ) );

  /* since the weight field is now extended, there will be uninitialized
     elements.  initialize the spot in the core image which holds
     the weight field */
  bpipe_dpktf_init( dpktf, data, &init );

  /* loop through data packets */
  bpipe_errno = BPNOERROR;
  while( bpipe_read_dpkts( bpipe, data, (size_t) 1 ) )
    if ( bpipe_write_dpkt( bpipe, data, bpo ) )
      error( "error writing photon" );

  if ( bpipe_errno != BPNOERROR )
    error( bpipe_strerror( bpipe_errno ) );
  
  bpipe_delete(bpipe);

  return EXIT_SUCCESS;
}
