-- --8<--8<--8<--8<--
--
-- Copyright (C) 2007 Smithsonian Astrophysical Observatory
--
-- This file is part of chandra.saotrace.coords
--
-- AXAFCoords_lua is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local math = require( "math" )

module( ... )

local pi  = math.pi
local mod = math.mod

-------------------------

-- ALL UNITS ARE RADIANS

-------------------------

-- convert from osac_polar to HRMA Left Handed Spherical Coordinates
-- ( AXAF-HSC-1.1 )
function osac_polar_2_HSC11( theta, phi )

   if theta ~= 0 then

      phi = mod( phi + pi, 2 * pi )

   end

  return theta, phi
end

-- convert from HRMA Left Handed Spherical Coordinates
-- ( AXAF-HSC-1.1 ) to osac_polar
function HSC11_2_osac_polar( theta, phi )

   if theta ~= 0 then

      phi = mod( phi + pi, 2 * pi )

   end

  return theta, phi
end

-- convert from XRCF pitch/yaw to OSAC el/az
function pitchyaw_2_osac_elaz( pitch, yaw )

  return -pitch, -yaw

end

-- convert from raygen_polar to Mirror Spherical Coordinates
function raygen_polar_to_MSC( theta, phi )

   if theta ~= 0 then

      phi = mod( phi + pi, 2 * pi )

   end

   return theta, phi

end

-- convert from Mirror Spherical Coordinates to raygen_polar
function MSC_to_raygen_polar( theta, phi )

   if theta ~= 0 then

      phi = mod( phi + pi, 2 * pi )

   end

  return theta, phi
end
