local coords     = require( 'saotrace.raygen.coords')
local tables     = require( 'saotrace.suplib.tables')
local units      = require( 'saotrace.raygen.units')
local setmetatable = setmetatable
local pairs = pairs

local M = {}
setfenv( 1, M )

_vspec = {
   default = { theta = 0, phi = 0 },

   type = {

      -- this entry will match { theta = xx, phi =xx } if coord is not
      -- specified

      raygen = {
	 vtable = {
	    theta = { type = 'zpos_angle_arcminute' , default = { 0, units.angular.radian } },
	    phi   = { type = 'zpos_angle_degree', default = { 0, units.angular.radian } },
	    coord = { enum = 'raygen', default = 'raygen' }
	 },
	 after = function( arg )
		    arg.coord = nil
		    return true, arg
		 end
      },

      elaz = {
	 vtable = {
	    el = { type = 'zpos_angle_arcminute', default = { 0, units.angular.radian } },
	    az = { type = 'zpos_angle_arcminute', default = { 0, units.angular.radian } },
	    coord = { enum = 'osac-elaz' },
	 },
	 after = function( arg )
		       local theta, phi = coords.osac_elaz_2_osac_polar( arg.el[1], arg.az[1] )
		       theta, phi = coords.osac_polar_2_raygen_polar( theta, phi )
		       return true, { theta = { theta, units.angular.radian },
				      phi   = { phi, units.angular.radian }
				   }
		    end
      },


   }

}

function M:new()

   local obj = {}
   obj._vspec = tables.copy( self._vspec, true )
   setmetatable( obj, self )
   self.__index = self

   return obj

end

function M:vspec()
   return self._vspec
 end

function M:add( name, entry )

   self._vspec.type[name] = entry

end

function M:delete( name )

   self._vspec.type[name] = nil

end


function M:default( name )

   local default
   local vtype = self._vspec.type

   for k,v in pairs( vtype ) do
      if v.vtable.coord.default ~= nil then
	 default = k
      end
   end

   if name ~= nil then
      if vtype[name] == nil then
	 error( "unregistered position type: "..name )
      end
      vtype[default].vtable.coord.default = nil
      vtype[name].vtable.coord.default = vtype[name].vtable.coord.enum
   end

   return default

end

return M
