-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.suplib
--
-- saotrace.suplib is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local next = next
local type = type
local pairs = pairs
local ipairs = ipairs
local table = require('table')
local insert = table.insert

module( ... )

---------------------------------------------------------------------
-- a simple function to copy a table.  it can perform "deep" copies,
-- but cannot handle recursive tables, will go into an infinite loop.

function copy ( what, deep )

   local tcopy = {}             -- create a new table
   local i, v = next(what, nil)  -- i is an index of t, v = t[i]

   while i do

      if type(v)=="table" and deep then
	 v = copy(v, deep) 
      end

      tcopy[i] = v

      i, v = next(what, i)        -- get next index
   end

  return tcopy

end

function merge( dst, ... )

   dst = dst or {}

   for _, src in ipairs{ ... } do

      for k,v in pairs( src ) do

	 if 'table' == type(v) then

	    dst[k] = dst[k] or {}
	    merge( dst[k], v )
	 else
	    dst[k] = v
	 end
      end

   end

   return dst

end

function filter ( t, func )

   local u = {}

   for k,v in pairs( t ) do
      if func( k, v ) then
	 u[k] = v
      end
   end

   return u

end



function filter_type ( t, types, out )

   local u = {}
   local f = {}

   for _,v in pairs( types ) do
      f[v] = true
   end

   if out then

      for k,v in pairs( t ) do

	 if not f[type(v)] then
	    u[k] = v
	 end

      end

   else

      for k,v in pairs( t ) do

	 if f[type(v)] then
	    u[k] = v
	 end

      end

   end

   return u

end


function filter_matched_keys ( master, t )

   local u = {}

   for k in pairs( master ) do

      u[k] = t[k]

   end

   return u
end


function filter_keys ( t, keys )

   local u = {}

   for _,k in pairs( list ) do

      u[k] = t[k]

   end

   return u
end

function keys( t, use_k_as_index )
   local u = {}

   if use_k_as_index then

      for k in pairs( t ) do
	 u[k] = k
      end

   else

      for k in pairs( t ) do
	 insert( u, k )
      end

   end

   return u
end

function values( t )
   local u = {}
   for _,v in pairs( t ) do
      insert( u, v )
   end

   return u
end

function invert( t )

   local u = {}
   for k,v in pairs( t ) do
      u[v] = k
   end

   return u

end


--- extract entries from a table
-- @param t the table
-- @keys  the keys to extract (set to nil to use keys in map)
-- @map   optional table where key=requested  keyname, value = keyname in table
--
-- if keys is nil, all keys are extracted from t, renaming keys as specified
-- in map
function extract( t, ks, map )

   map = map or {}

   if ks == nil then

      ks = keys(t, true)
      for k,v in pairs( map ) do
	 ks[v] = k
      end

   end

   local u = {}

   for _,k in pairs( ks ) do
      -- can't use u[k] = t[ map[k] or k ]
      -- as map[k] may be a boolean.
      local mk = map[k]

      if mk ~= nil then
	 u[k] = t[mk]
      else
	 u[k] = t[k]
      end
   end

   return u

end
